/*
 * Decompiled with CFR 0.152.
 */
package de.svenkubiak.mangooio.mongodb;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.result.DeleteResult;
import dev.morphia.Datastore;
import dev.morphia.DeleteOptions;
import dev.morphia.Morphia;
import dev.morphia.query.Query;
import io.mangoo.core.Config;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;

@Singleton
public class MongoDB {
    private static final Logger LOG = LogManager.getLogger(MongoDB.class);
    private static final int DEFAULT_MONGODB_PORT = 27017;
    private static final String DEFAULT_MORPHIA_PACKAGE = "MyMorphiaPackage";
    private static final String DEFAULT_MONGODB_NAME = "MyMongoDB";
    private static final String DEFAULT_MONGODB_HOST = "localhost";
    private static final String MONGODB_HOST = "mongodb.host";
    private static final String MONGODB_PORT = "mongodb.port";
    private static final String MONGODB_USER = "mongodb.user";
    private static final String MONGODB_PASS = "mongodb.pass";
    private static final String MONGODB_AUTH = "mongodb.auth";
    private static final String MONGODB_DBNAME = "mongodb.dbname";
    private static final String MONGODB_AUTHDB = "mongodb.authdb";
    private static final String MORPHIA_PACKAGE = "morphia.package";
    private static final String MORPHIA_INIT = "morphia.init";
    private Datastore datastore;
    private MongoClient mongoClient;
    private Config config;

    @Inject
    public MongoDB(Config config) {
        this.config = config;
        this.connect();
        if (this.config.getBoolean(MORPHIA_INIT, false)) {
            this.morphify();
        }
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    private void connect() {
        String string = this.config.getString(MONGODB_HOST, DEFAULT_MONGODB_HOST);
        int n = this.config.getInt(MONGODB_PORT, 27017);
        String string2 = this.config.getString(MONGODB_USER, null);
        String string3 = this.config.getString(MONGODB_PASS, null);
        String string4 = this.config.getString(MONGODB_AUTHDB);
        if (this.config.getBoolean(MONGODB_AUTH, false) && StringUtils.isNotBlank((CharSequence)string2) && StringUtils.isNotBlank((CharSequence)string3) && StringUtils.isNotBlank((CharSequence)string4)) {
            this.mongoClient = MongoClients.create((ConnectionString)new ConnectionString("mongodb://" + string2 + ":" + string3 + "@" + string + ":" + n + "/" + string4));
            LOG.info("Successfully created MongoClient @ {}:{} with authentication", (Object)string, (Object)n);
        } else {
            this.mongoClient = MongoClients.create((ConnectionString)new ConnectionString("mongodb://" + string + ":" + n));
            LOG.info("Successfully created MongoClient @ {}:{} ***without**** authentication", (Object)string, (Object)n);
        }
    }

    private void morphify() {
        String string = this.config.getString(MORPHIA_PACKAGE, DEFAULT_MORPHIA_PACKAGE);
        String string2 = this.config.getString(MONGODB_DBNAME, DEFAULT_MONGODB_NAME);
        this.datastore = Morphia.createDatastore((MongoClient)this.mongoClient, (String)string2);
        LOG.info("Mapped Morphia models of package '" + string + "' and created Morphia Datastore with database '" + string2 + "'");
    }

    public void ensureIndexes() {
        this.datastore.ensureIndexes();
    }

    public void ensureCaps() {
        this.datastore.ensureCaps();
    }

    public <T> T findById(Object object, Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to find an object by id, but given class is null");
        Preconditions.checkNotNull((Object)object, (Object)"Tryed to find an object by id, but given id is null");
        return (T)((Query)this.datastore.find(clazz).field("_id").equal(object instanceof ObjectId ? object : new ObjectId(String.valueOf(object)))).first();
    }

    public <T> List<T> findAll(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to get all morphia objects of a given object, but given object is null");
        return this.datastore.find(clazz).execute().toList();
    }

    public <T> long countAll(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to count all a morphia objects of a given object, but given object is null");
        return this.datastore.find(clazz).count();
    }

    public void save(Object object) {
        Preconditions.checkNotNull((Object)object, (Object)"Tryed to save a morphia object, but a given object is null");
        this.datastore.save(object);
    }

    public DeleteResult delete(Object object) {
        Objects.requireNonNull(object, "Tryed to delete a morphia object, but given object is null");
        return this.datastore.delete(object);
    }

    public <T> DeleteResult deleteAll(Class<T> clazz) {
        Objects.requireNonNull(clazz, "Tryed to delete list of mapped morphia objects, but given class is null");
        return this.datastore.find(clazz).remove(new DeleteOptions().multi(true));
    }

    public void dropDatabase() {
        this.datastore.getDatabase().drop();
    }
}

