/*
 * Decompiled with CFR 0.152.
 */
package mangoo.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import mangoo.build.Runner;
import mangoo.build.Trigger;
import mangoo.build.Watcher;
import mangoo.io.core.Application;
import mangoo.io.utils.MinificationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.NONE, threadSafe=true)
public class MangooMojo
extends AbstractMojo {
    private static final String[] DEFAULT_EXCLUDE_PATTERNS = new String[]{"(.*)" + Pattern.quote(File.separator) + "templates" + Pattern.quote(File.separator) + "(.*)ftl", "(.*)" + Pattern.quote(File.separator) + "assets" + Pattern.quote(File.separator) + "(.*)"};
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="mangoo.skip", defaultValue="false", required=true)
    private boolean skip;
    @Parameter(property="mangoo.outputDirectory", defaultValue="${project.build.outputDirectory}", required=true)
    private String buildOutputDirectory;
    @Parameter(property="mangoo.watchDirs", required=false)
    private File[] watchDirs;
    @Parameter(property="mangoo.watchAllClassPathDirs", defaultValue="false", required=true)
    private boolean watchAllClassPathDirs;
    @Parameter(property="mangoo.watchAllClassPathJars", defaultValue="false", required=true)
    private boolean watchAllClassPathJars;
    @Parameter(property="mangoo.includes", required=false)
    protected List<String> includes;
    @Parameter(property="mangoo.excludes", required=false)
    private List<String> excludes;
    @Parameter(property="mangoo.useDefaultExcludes", defaultValue="true", required=true)
    protected boolean useDefaultExcludes;
    @Parameter(property="mangoo.settleDownMillis", defaultValue="500", required=false)
    private Long settleDownMillis;

    public void execute() throws MojoExecutionException {
        Object object2;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip flag is on. Will not execute.");
            return;
        }
        this.initMojo();
        this.checkClasses(this.buildOutputDirectory);
        MinificationUtils.setBasePath((String)this.project.getBasedir().getAbsolutePath());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.buildOutputDirectory);
        for (Object object2 : this.project.getArtifacts()) {
            arrayList.add(object2.getFile().toString());
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.includes);
        object2 = new LinkedHashSet<String>(this.excludes);
        LinkedHashSet<Path> linkedHashSet2 = new LinkedHashSet<Path>();
        linkedHashSet2.add(FileSystems.getDefault().getPath(this.buildOutputDirectory, new String[0]).toAbsolutePath());
        if (this.watchDirs != null) {
            for (File file : this.watchDirs) {
                linkedHashSet2.add(file.toPath().toAbsolutePath());
            }
        }
        this.getArtifacts((Set<String>)linkedHashSet, (Set<String>)object2, linkedHashSet2);
        this.startRunner(arrayList, (Set<String>)linkedHashSet, (Set<String>)object2, linkedHashSet2);
    }

    private void startRunner(List<String> list, Set<String> set, Set<String> set2, Set<Path> set3) {
        try {
            Runner runner = new Runner(Application.class.getName(), StringUtils.join(list, (String)File.pathSeparator), this.project.getBasedir());
            Trigger trigger = new Trigger(runner);
            trigger.setSettleDownMillis(this.settleDownMillis);
            trigger.start();
            Watcher watcher = new Watcher(set3, set, set2, trigger);
            runner.restart();
            watcher.run();
        }
        catch (IOException iOException) {
            this.getLog().error((Throwable)iOException);
        }
    }

    private void getArtifacts(Set<String> set, Set<String> set2, Set<Path> set3) {
        for (Artifact artifact : this.project.getArtifacts()) {
            File file = artifact.getFile();
            if (file.isDirectory() && this.watchAllClassPathDirs) {
                set3.add(file.toPath().toAbsolutePath());
                continue;
            }
            if (!file.getName().endsWith(".jar") || !this.watchAllClassPathJars) continue;
            File file2 = file.getParentFile();
            Path path = file2.toPath().toAbsolutePath();
            String string = file2.getAbsolutePath() + File.separator;
            string = string.replace("\\", "\\\\");
            if (!set3.contains(path)) {
                set2.add(string + "(.*)$");
            }
            set.add(string + file.getName() + "$");
            set3.add(path);
        }
    }

    private void initMojo() {
        if (this.useDefaultExcludes) {
            this.excludes.addAll(Arrays.asList(DEFAULT_EXCLUDE_PATTERNS));
        }
    }

    public void checkClasses(String string) {
        if (!new File(string).exists()) {
            this.getLog().error((CharSequence)("Directory with classes does not exist: " + string));
            System.exit(1);
        }
    }
}

