/*
 * Decompiled with CFR 0.152.
 */
package mangoo.build;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import mangoo.build.Trigger;
import mangoo.io.utils.MinificationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Watcher
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Watcher.class);
    private final Trigger trigger;
    private final Set<String> includes;
    private final Set<String> excludes;
    private final WatchService watchService = FileSystems.getDefault().newWatchService();
    private final Map<WatchKey, Path> watchKeys = new HashMap<WatchKey, Path>();
    private final AtomicInteger takeCount;
    private boolean shutdown;

    public Watcher(Set<Path> set, Set<String> set2, Set<String> set3, Trigger trigger) throws IOException {
        this.includes = set2;
        this.excludes = set3;
        this.trigger = trigger;
        this.takeCount = new AtomicInteger(0);
        for (Path path : set) {
            this.registerAll(path);
        }
    }

    public void doShutdown() {
        this.shutdown = true;
    }

    private void registerAll(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Watcher.this.register(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void register(Path path) throws IOException {
        WatchKey watchKey = path.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE}, SensitivityWatchEventModifier.HIGH);
        this.watchKeys.put(watchKey, path);
    }

    @Override
    public void run() {
        while (true) {
            WatchKey watchKey;
            try {
                watchKey = this.watchService.take();
                this.takeCount.incrementAndGet();
            }
            catch (InterruptedException interruptedException) {
                if (!this.shutdown) {
                    LOG.error("Unexpectedly interrupted while waiting for take()", (Throwable)interruptedException);
                }
                return;
            }
            Path path = this.watchKeys.get(watchKey);
            if (path == null) {
                LOG.error("WatchKey not recognized!!");
                continue;
            }
            this.handleEvents(watchKey, path);
            if (watchKey.reset()) continue;
            this.watchKeys.remove(watchKey);
            if (this.watchKeys.isEmpty()) break;
        }
    }

    private void handleEvents(WatchKey watchKey, Path path) {
        for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
            WatchEvent.Kind<?> kind = watchEvent.kind();
            if (StandardWatchEventKinds.OVERFLOW.equals(kind)) continue;
            WatchEvent<?> watchEvent2 = watchEvent;
            Path path2 = (Path)watchEvent2.context();
            Path path3 = path.resolve(path2);
            if (StandardWatchEventKinds.ENTRY_MODIFY.equals(kind) && !path3.toFile().isDirectory()) {
                this.handleNewOrModifiedFile(path3);
            }
            if (!StandardWatchEventKinds.ENTRY_CREATE.equals(kind)) continue;
            if (!path3.toFile().isDirectory()) {
                this.handleNewOrModifiedFile(path3);
            }
            try {
                if (!Files.isDirectory(path3, LinkOption.NOFOLLOW_LINKS)) continue;
                this.registerAll(path3);
            }
            catch (IOException iOException) {
                LOG.error("Something fishy happened. Unable to register new dir for watching", (Throwable)iOException);
            }
        }
    }

    public void handleNewOrModifiedFile(Path path) {
        RuleMatch ruleMatch;
        String string = path.toFile().getAbsolutePath();
        if (this.isAsset(string)) {
            MinificationUtils.minify((String)string);
        }
        if ((ruleMatch = Watcher.matchRule(this.includes, this.excludes, string)).proceed) {
            this.trigger.trigger();
        }
    }

    private boolean isAsset(String string) {
        return string != null && !string.contains("min") && string.endsWith("css") || string.endsWith("js");
    }

    public static RuleMatch matchRule(Set<String> set, Set<String> set2, String string) {
        if (set != null) {
            for (String string2 : set) {
                if (!string.matches(string2)) continue;
                return new RuleMatch(true);
            }
        }
        if (set2 != null) {
            for (String string2 : set2) {
                if (!string.matches(string2)) continue;
                return new RuleMatch(false);
            }
        }
        return new RuleMatch(true);
    }

    public static boolean checkIfWouldBeExcluded(Set<String> set, String string) {
        return !Watcher.matchRule(null, set, string).proceed;
    }

    public static class RuleMatch {
        private boolean proceed;

        public RuleMatch(boolean bl) {
            this.proceed = bl;
        }
    }

    public static enum RuleType {
        NONE,
        INCLUDE,
        EXCLUDE;

    }
}

