/*
 * Decompiled with CFR 0.152.
 */
package mangoo.build;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import mangoo.build.Runner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Trigger
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(Trigger.class);
    private boolean shutdown = false;
    private final AtomicInteger restartCount;
    private final AtomicInteger triggerCount;
    private final ReentrantLock restartLock;
    private final Condition restartRequested;
    private final Runner runner;
    private long settleDownMillis = 500L;

    public Trigger(Runner runner) {
        this.setDaemon(true);
        this.setName("DelayedRestartTrigger");
        this.restartCount = new AtomicInteger(0);
        this.triggerCount = new AtomicInteger(0);
        this.restartLock = new ReentrantLock();
        this.restartRequested = this.restartLock.newCondition();
        this.runner = runner;
    }

    public void doShutdown() {
        this.shutdown = true;
        this.interrupt();
    }

    public int getRestartCount() {
        return this.restartCount.get();
    }

    public int getAccumulatedTriggerCount() {
        return this.triggerCount.get();
    }

    public long getSettleDownMillis() {
        return this.settleDownMillis;
    }

    public void setSettleDownMillis(long l) {
        this.settleDownMillis = l;
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                this.restartLock.lock();
                try {
                    if (this.triggerCount.get() <= 0) {
                        this.restartRequested.await();
                    }
                    this.restartCount.incrementAndGet();
                }
                finally {
                    this.restartLock.unlock();
                }
                LOG.info("------------------------------------------------------------------------");
                LOG.info("Restart process...");
                int n = 0;
                do {
                    LOG.info("Delaying restart for " + this.settleDownMillis + " ms to wait for file changes to settle");
                    n += this.triggerCount.getAndSet(0);
                    this.sleep();
                } while (this.triggerCount.get() != 0);
                LOG.info("Restarting dev mode (" + n + " file change(s) detected)");
                LOG.info("------------------------------------------------------------------------");
                this.runner.restart();
            }
            catch (InterruptedException interruptedException) {
                if (this.shutdown) break;
                LOG.error("Unexpected thread interrupt (maybe you are shutting down Maven?)", (Throwable)interruptedException);
                break;
            }
        }
    }

    private void sleep() {
        try {
            Thread.sleep(this.settleDownMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void trigger() {
        this.restartLock.lock();
        try {
            this.triggerCount.incrementAndGet();
            this.restartRequested.signal();
        }
        finally {
            this.restartLock.unlock();
        }
    }
}

