/*
 * Decompiled with CFR 0.152.
 */
package mangoo.build;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.exec.listener.ProcessListener;

public class Runner {
    private static final Logger LOG = LoggerFactory.getLogger(Runner.class);
    private OutputStream outputStream = System.out;
    private StartedProcess startedProcess;
    private final AtomicBoolean restarting;
    private final String mainClass;
    private final String classpath;
    private final File mavenBaseDir;

    public Runner(String string, String string2, File file) {
        this.mainClass = string;
        this.classpath = string2;
        this.mavenBaseDir = file;
        this.restarting = new AtomicBoolean(false);
    }

    public OutputStream getOutput() {
        return this.outputStream;
    }

    public void setOutput(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public StartedProcess getActiveProcess() {
        return this.startedProcess;
    }

    public void setActiveProcess(StartedProcess startedProcess) {
        this.startedProcess = startedProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        Runner runner = this;
        synchronized (runner) {
            this.restarting.set(true);
            try {
                if (this.startedProcess != null) {
                    this.startedProcess.getProcess().destroy();
                    this.startedProcess.getFuture().get();
                }
                this.startedProcess = this.startProcess();
            }
            catch (IOException | InterruptedException | ExecutionException exception) {
                LOG.error("Something fishy happenend. Unable to cleanly restart!", (Throwable)exception);
                LOG.error("You'll probably need to restart maven?");
            }
            finally {
                this.restarting.set(false);
            }
        }
    }

    private StartedProcess startProcess() throws IOException {
        ProcessExecutor processExecutor = this.buildProcessExecutor();
        return processExecutor.start();
    }

    private ProcessExecutor buildProcessExecutor() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = System.getProperty("java.home");
        String string2 = string + File.separator + "bin" + File.separator + "java";
        arrayList.add(string2);
        arrayList.add("-Dapplication.mode=dev");
        arrayList.add("-cp");
        arrayList.add(this.classpath);
        arrayList.add(this.mainClass);
        return new ProcessExecutor(arrayList).directory(this.mavenBaseDir).destroyOnExit().addListener(new ProcessListener(){

            public void afterStop(Process process) {
                if (!Runner.this.restarting.get()) {
                    LOG.error("JVM process terminated (next file change will attempt to restart it)");
                }
            }
        }).redirectErrorStream(true).redirectOutput(this.outputStream);
    }
}

