/*
 * Decompiled with CFR 0.152.
 */
package de.svenkubiak.jpushover.services;

import de.svenkubiak.jpushover.http.PushoverResponse;
import de.svenkubiak.jpushover.services.AsyncExecutor;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AsyncService<T> {
    private static AsyncService<?> INSTANCE;
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);

    public static AsyncService<?> getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AsyncService();
        }
        return INSTANCE;
    }

    public Future<PushoverResponse> execute(AsyncExecutor<PushoverResponse> asyncExecutor) throws InterruptedException, ExecutionException {
        return this.executorService.submit(asyncExecutor);
    }

    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }
}

