/*
 * Decompiled with CFR 0.152.
 */
package de.svenkubiak.jpushover.listener;

import de.svenkubiak.jpushover.interfaces.MessageListener;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CompletionStage;

public class WebSocketListener
implements WebSocket.Listener {
    private MessageListener messageListener;

    public WebSocketListener(MessageListener messageListener) {
        Objects.requireNonNull(messageListener, "messageListener can not be null");
        this.messageListener = messageListener;
    }

    @Override
    public void onError(WebSocket webSocket, Throwable throwable) {
        this.messageListener.onError();
        WebSocket.Listener.super.onError(webSocket, throwable);
    }

    @Override
    public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer byteBuffer, boolean bl) {
        if (byteBuffer != null) {
            String string;
            switch (string = StandardCharsets.UTF_8.decode(byteBuffer).toString()) {
                case "!": {
                    this.messageListener.onMessage();
                    break;
                }
                case "E": {
                    this.messageListener.onError();
                    break;
                }
                case "R": {
                    this.messageListener.onError();
                    break;
                }
                case "A": {
                    this.messageListener.onError();
                    break;
                }
            }
        }
        return WebSocket.Listener.super.onBinary(webSocket, byteBuffer, bl);
    }
}

