/*
 * Decompiled with CFR 0.152.
 */
package de.svenkubiak.jpushover.apis;

import de.svenkubiak.jpushover.exceptions.JPushoverException;
import de.svenkubiak.jpushover.http.PushoverResponse;
import de.svenkubiak.jpushover.interfaces.MessageListener;
import de.svenkubiak.jpushover.listener.WebSocketListener;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.WebSocket;
import java.time.Duration;
import java.util.Objects;

public class OpenClient {
    private static final String LOGIN_URL = "https://api.pushover.net/1/users/login.json";
    private static final String DEVICE_URL = "https://api.pushover.net/1/devices.json";
    private static final String MESSAGES_URL = "https://api.pushover.net/1/messages.json";
    private static final String DELETE_URL = "https://api.pushover.net/1/devices/###DEVICE_ID###/update_highest_message.json";
    private static final String WEBSOCKET_URL = "wss://client.pushover.net/push";

    public PushoverResponse login(String string, String string2, String string3) throws JPushoverException {
        Objects.requireNonNull(string, "email can not be null");
        Objects.requireNonNull(string2, "password can not be null");
        StringBuilder stringBuilder = new StringBuilder().append("email").append("=").append(string).append("&").append("password").append("=").append(string2);
        if (string3 != null) {
            stringBuilder.append("&").append("twofa").append("=").append(string3);
        }
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(LOGIN_URL)).timeout(Duration.ofSeconds(5L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(stringBuilder.toString())).build();
        PushoverResponse pushoverResponse = PushoverResponse.create().isSuccessful(false);
        try {
            HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            pushoverResponse.httpStatus(httpResponse.statusCode()).response(httpResponse.body()).isSuccessful(httpResponse.statusCode() == 200);
        }
        catch (IOException | InterruptedException exception) {
            throw new JPushoverException("Login failed", exception);
        }
        return pushoverResponse;
    }

    public PushoverResponse login(String string, String string2) throws JPushoverException {
        return this.login(string, string2, null);
    }

    public String messages(String string, String string2) throws JPushoverException {
        Objects.requireNonNull(string, "secret can not be null");
        Objects.requireNonNull(string2, "deviceId can not be null");
        StringBuilder stringBuilder = new StringBuilder().append("?secret").append("=").append(string).append("&").append("deviceId").append("=").append(string2);
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(MESSAGES_URL + stringBuilder.toString())).timeout(Duration.ofSeconds(5L)).header("Content-Type", "application/json").build();
        String string3 = null;
        try {
            HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            string3 = httpResponse.body();
        }
        catch (IOException | InterruptedException exception) {
            throw new JPushoverException("Failed to get messages", exception);
        }
        return string3;
    }

    public PushoverResponse deleteMessages(String string, String string2, String string3) throws JPushoverException {
        Objects.requireNonNull(string2, "secret can not be null");
        Objects.requireNonNull(string, "deviceId can not be null");
        Objects.requireNonNull(string3, "deviceId can not be null");
        StringBuilder stringBuilder = new StringBuilder().append("secret").append("=").append(string).append("&").append("message").append("=").append(string3);
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(DELETE_URL.replace("###DEVICE_ID###", string2))).timeout(Duration.ofSeconds(5L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(stringBuilder.toString())).build();
        PushoverResponse pushoverResponse = PushoverResponse.create().isSuccessful(false);
        try {
            HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            pushoverResponse.httpStatus(httpResponse.statusCode()).response(httpResponse.body()).isSuccessful(httpResponse.statusCode() == 200);
        }
        catch (IOException | InterruptedException exception) {
            throw new JPushoverException("Failed to delete messages", exception);
        }
        return pushoverResponse;
    }

    public boolean listen(String string, String string2, MessageListener messageListener) {
        Objects.requireNonNull(string, "secret can not be null");
        Objects.requireNonNull(string2, "deviceId name can not be null");
        Objects.requireNonNull(messageListener, "messageListener can not be null");
        HttpClient httpClient = HttpClient.newBuilder().build();
        WebSocket.Builder builder = httpClient.newWebSocketBuilder();
        WebSocket webSocket = builder.buildAsync(URI.create(WEBSOCKET_URL), new WebSocketListener(messageListener)).join();
        StringBuilder stringBuilder = new StringBuilder().append("login").append(":").append(string2).append(":").append(string).append("\n");
        webSocket.sendText(stringBuilder.toString(), true);
        return !webSocket.isInputClosed();
    }

    public PushoverResponse registerDevice(String string, String string2) throws JPushoverException {
        Objects.requireNonNull(string, "secret can not be null");
        Objects.requireNonNull(string2, "device name can not be null");
        StringBuilder stringBuilder = new StringBuilder().append("secret").append("=").append(string).append("&").append("name").append("=").append(string2).append("&os=O");
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(DEVICE_URL)).POST(HttpRequest.BodyPublishers.ofString(stringBuilder.toString())).build();
        PushoverResponse pushoverResponse = PushoverResponse.create().isSuccessful(false);
        try {
            HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (httpResponse.statusCode() == 200) {
                pushoverResponse.httpStatus(httpResponse.statusCode()).response(httpResponse.body()).isSuccessful(true);
            }
        }
        catch (IOException | InterruptedException exception) {
            throw new JPushoverException("Failed to register new device", exception);
        }
        return pushoverResponse;
    }
}

