/*
 * Decompiled with CFR 0.152.
 */
package de.svenkubiak.jpushover;

import com.google.common.base.Preconditions;
import de.svenkubiak.jpushover.JPushoverResponse;
import de.svenkubiak.jpushover.enums.Constants;
import de.svenkubiak.jpushover.enums.Priority;
import de.svenkubiak.jpushover.enums.Sound;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.Consts;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPushover {
    private static final Logger LOG = LoggerFactory.getLogger(JPushover.class);
    private String token;
    private String user;
    private String message;
    private String device;
    private String title;
    private String url;
    private String urlTitle;
    private String timestamp;
    private Priority priority;
    private Sound sound;

    public JPushover token(String string) {
        this.token = string;
        return this;
    }

    public JPushover user(String string) {
        this.user = string;
        return this;
    }

    public JPushover message(String string) {
        this.message = string;
        return this;
    }

    public JPushover device(String string) {
        this.device = string;
        return this;
    }

    public JPushover title(String string) {
        this.title = string;
        return this;
    }

    public JPushover url(String string) {
        this.url = string;
        return this;
    }

    public JPushover urlTitle(String string) {
        this.urlTitle = string;
        return this;
    }

    public JPushover timestamp(String string) {
        this.timestamp = string;
        return this;
    }

    public JPushover priority(Priority priority) {
        this.priority = priority;
        return this;
    }

    public JPushover sound(Sound sound) {
        this.sound = sound;
        return this;
    }

    public JPushoverResponse push() {
        Preconditions.checkNotNull((Object)this.token, (Object)"Token is required");
        Preconditions.checkNotNull((Object)this.user, (Object)"User is required");
        Preconditions.checkNotNull((Object)this.message, (Object)"Message is required");
        List list = Form.form().add(Constants.TOKEN.value(), this.token).add(Constants.USER.value(), this.user).add(Constants.MESSAGE.value(), this.message).add(Constants.DEVICE.value(), this.device).add(Constants.TITLE.value(), this.title).add(Constants.URL.value(), this.url).add(Constants.URLTITLE.value(), this.urlTitle).add(Constants.PRIORITY.value(), this.priority.value()).add(Constants.TIMESTAMP.value(), this.timestamp).add(Constants.SOUND.value(), this.sound.value()).build();
        HttpResponse httpResponse = null;
        JPushoverResponse jPushoverResponse = null;
        try {
            httpResponse = Request.Post((String)Constants.PUSHOVER_URL.value()).bodyForm((Iterable)list, Consts.UTF_8).execute().returnResponse();
            if (httpResponse != null) {
                int n = httpResponse.getStatusLine().getStatusCode();
                jPushoverResponse = new JPushoverResponse().httpStatus(n).response(IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)Consts.UTF_8)).isSuccessful(n == 200);
            }
        }
        catch (IOException iOException) {
            LOG.error("Failed to send message to pushover", (Throwable)iOException);
        }
        return jPushoverResponse == null ? new JPushoverResponse().isSuccessful(false) : jPushoverResponse;
    }
}

