/*
 * Decompiled with CFR 0.152.
 */
package de.stklcode.pubtrans.ura.model;

import de.stklcode.pubtrans.ura.model.Model;
import de.stklcode.pubtrans.ura.model.Stop;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

public final class Trip
implements Model {
    private static final long serialVersionUID = 7477381188869237381L;
    private static final int VISIT_ID = 7;
    private static final int LINE_ID = 8;
    private static final int LINE_NAME = 9;
    private static final int DIRECTION_ID = 10;
    private static final int DESTINATION_NAME = 11;
    private static final int DESTINATION_TEXT = 12;
    private static final int VEHICLE_ID = 13;
    private static final int TRIP_ID = 14;
    private static final int ESTIMATED_TIME = 15;
    private static final int NUM_OF_FIELDS = 16;
    private final Stop stop;
    private final String id;
    private final Integer visitID;
    private final String lineID;
    private final String lineName;
    private final Integer directionID;
    private final String destinationName;
    private final String destinationText;
    private final Long estimatedTime;
    private final String vehicleID;

    public Trip(String stopID, String stopName, String stopIndicator, Integer stopState, Double stopLatitude, Double stopLongitude, Integer visitID, String lineID, String lineName, Integer directionID, String destinationName, String destinationText, String vehicleID, String tripID, Long estimatedTime) {
        this(new Stop(stopID, stopName, stopIndicator, stopState, stopLatitude, stopLongitude), visitID, lineID, lineName, directionID, destinationName, destinationText, vehicleID, tripID, estimatedTime);
    }

    public Trip(Stop stop, Integer visitID, String lineID, String lineName, Integer directionID, String destinationName, String destinationText, String vehicleID, String tripID, Long estimatedTime) {
        this.stop = stop;
        this.visitID = visitID;
        this.lineID = lineID;
        this.lineName = lineName;
        this.directionID = directionID;
        this.destinationName = destinationName;
        this.destinationText = destinationText;
        this.vehicleID = vehicleID;
        this.id = tripID;
        this.estimatedTime = estimatedTime;
    }

    public Trip(List<Serializable> raw) throws IOException {
        this(raw, null);
    }

    public Trip(List<Serializable> raw, String version) throws IOException {
        if (raw == null || raw.size() < 16) {
            throw new IOException("Invalid number of fields");
        }
        this.stop = new Stop(raw);
        if (!(raw.get(7) instanceof Integer)) {
            throw Model.typeError(7, raw.get(7).getClass(), "Integer");
        }
        this.visitID = (Integer)raw.get(7);
        if (!(raw.get(8) instanceof String)) {
            throw Model.typeErrorString(8, raw.get(8).getClass());
        }
        this.lineID = (String)((Object)raw.get(8));
        if (!(raw.get(9) instanceof String)) {
            throw Model.typeErrorString(9, raw.get(9).getClass());
        }
        this.lineName = (String)((Object)raw.get(9));
        if (raw.get(10) instanceof String || raw.get(10) instanceof Integer || raw.get(10) instanceof Long) {
            this.directionID = Integer.valueOf(raw.get(10).toString());
            if (this.directionID < 0 || this.directionID > 2) {
                throw new IOException("Direction out of range. Expected 1 or 2, found " + this.directionID);
            }
        } else {
            throw Model.typeError(10, raw.get(10).getClass(), "String/Long/Integer");
        }
        if (!(raw.get(11) instanceof String)) {
            throw Model.typeErrorString(11, raw.get(11).getClass());
        }
        this.destinationName = (String)((Object)raw.get(11));
        if (!(raw.get(12) instanceof String)) {
            throw Model.typeErrorString(12, raw.get(12).getClass());
        }
        this.destinationText = (String)((Object)raw.get(12));
        if (raw.get(13) instanceof String || raw.get(13) instanceof Integer || raw.get(13) instanceof Long) {
            this.vehicleID = raw.get(13).toString();
        } else if (raw.get(13) == null) {
            this.vehicleID = null;
        } else {
            throw Model.typeError(13, raw.get(13).getClass(), "String/Integer/Long");
        }
        if (!(raw.get(14) instanceof String || raw.get(14) instanceof Integer || raw.get(14) instanceof Long)) {
            throw Model.typeError(14, raw.get(14).getClass(), "String/Integer/Long");
        }
        this.id = raw.get(14).toString();
        if (!(raw.get(15) instanceof Long)) {
            throw Model.typeError(15, raw.get(15).getClass(), "Long");
        }
        this.estimatedTime = (Long)raw.get(15);
    }

    public Stop getStop() {
        return this.stop;
    }

    public String getId() {
        return this.id;
    }

    public Integer getVisitID() {
        return this.visitID;
    }

    public String getLineID() {
        return this.lineID;
    }

    public String getLineName() {
        return this.lineName;
    }

    public Integer getDirectionID() {
        return this.directionID;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public String getDestinationText() {
        return this.destinationText;
    }

    public Long getEstimatedTime() {
        return this.estimatedTime;
    }

    public String getVehicleID() {
        return this.vehicleID;
    }
}

