/*
 * Decompiled with CFR 0.152.
 */
package de.stklcode.pubtrans.ura;

import java.io.Serializable;
import java.time.Duration;

public class UraClientConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_INSTANT_PATH = "/interfaces/ura/instant_V1";
    private static final String DEFAULT_STREAM_PATH = "/interfaces/ura/stream_V1";
    private final String baseURL;
    private final String instantPath;
    private final String streamPath;
    private final Duration connectTimeout;
    private final Duration timeout;

    public static Builder forBaseURL(String baseURL) {
        return new Builder(baseURL);
    }

    private UraClientConfiguration(Builder builder) {
        this.baseURL = builder.baseURL;
        this.instantPath = builder.instantPath;
        this.streamPath = builder.streamPath;
        this.connectTimeout = builder.connectTimeout;
        this.timeout = builder.timeout;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getInstantPath() {
        return this.instantPath;
    }

    public String getStreeamPath() {
        return this.streamPath;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public static class Builder {
        private final String baseURL;
        private String instantPath;
        private String streamPath;
        private Duration connectTimeout;
        private Duration timeout;

        private Builder(String baseURL) {
            this.baseURL = baseURL;
            this.instantPath = UraClientConfiguration.DEFAULT_INSTANT_PATH;
            this.streamPath = UraClientConfiguration.DEFAULT_STREAM_PATH;
            this.connectTimeout = null;
            this.timeout = null;
        }

        public Builder withInstantPath(String instantPath) {
            this.instantPath = instantPath;
            return this;
        }

        public Builder withStreamPath(String streamPath) {
            this.streamPath = streamPath;
            return this;
        }

        public Builder withConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder withTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public UraClientConfiguration build() {
            return new UraClientConfiguration(this);
        }
    }
}

