/*
 * Decompiled with CFR 0.152.
 */
package de.stklcode.pubtrans.ura.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.stklcode.pubtrans.ura.model.Trip;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class AsyncUraTripReader
implements AutoCloseable {
    private static final Integer RES_TYPE_PREDICTION = 1;
    private static final Integer RES_TYPE_URA_VERSION = 4;
    private final List<Consumer<Trip>> consumers;
    private final URL url;
    private CompletableFuture<Void> future;
    private boolean canceled;

    public AsyncUraTripReader(URL url, Consumer<Trip> consumer) {
        this.url = url;
        this.consumers = new ArrayList<Consumer<Trip>>();
        this.consumers.add(consumer);
    }

    public AsyncUraTripReader(URL url, List<Consumer<Trip>> consumers) {
        this.url = url;
        this.consumers = new ArrayList<Consumer<Trip>>(consumers);
    }

    public void open() {
        if (this.future != null) {
            throw new IllegalStateException("Reader already opened");
        }
        this.future = CompletableFuture.runAsync(() -> {
            ObjectMapper mapper = new ObjectMapper();
            try (InputStream is = AsyncUraTripReader.getInputStream(this.url);
                 BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                String version = null;
                String line = br.readLine();
                while (line != null && !this.canceled) {
                    List l = (List)mapper.readValue(line, List.class);
                    if (l != null && !l.isEmpty()) {
                        if (l.get(0).equals(RES_TYPE_URA_VERSION)) {
                            version = l.get(1).toString();
                        } else if (l.get(0).equals(RES_TYPE_PREDICTION)) {
                            Trip trip = new Trip(l, version);
                            this.consumers.forEach(c -> c.accept(trip));
                        }
                    }
                    line = br.readLine();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read from API", e);
            }
        });
    }

    public void addConsumer(Consumer<Trip> consumer) {
        this.consumers.add(consumer);
    }

    @Override
    public void close() {
        if (this.future == null) {
            return;
        }
        this.canceled = true;
        try {
            this.future.get(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Failed to read from API", e);
        }
        catch (TimeoutException e) {
            this.future.cancel(true);
        }
        finally {
            this.future = null;
        }
    }

    private static InputStream getInputStream(URL url) throws IOException {
        return url.openStream();
    }
}

