/*
 * Decompiled with CFR 0.152.
 */
package de.stklcode.pubtrans.ura;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.stklcode.pubtrans.ura.model.Stop;
import de.stklcode.pubtrans.ura.model.Trip;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class UraClient {
    private static final String DEFAULT_INSTANT_URL = "/interfaces/ura/instant_V1";
    private static final String DEFAULT_STREAM_URL = "/interfaces/ura/stream_V1";
    private static final String PAR_STOP_ID = "StopID";
    private static final String PAR_STOP_NAME = "StopPointName";
    private static final String PAR_STOP_STATE = "StopPointState";
    private static final String PAR_STOP_INDICATOR = "StopPointIndicator";
    private static final String PAR_GEOLOCATION = "Latitude,Longitude";
    private static final String PAR_VISIT_NUMBER = "VisitNumber";
    private static final String PAR_LINE_ID = "LineID";
    private static final String PAR_LINE_NAME = "LineName";
    private static final String PAR_DIR_ID = "DirectionID";
    private static final String PAR_DEST_NAME = "DestinationName";
    private static final String PAR_DEST_TEXT = "DestinationText";
    private static final String PAR_VEHICLE_ID = "VehicleID";
    private static final String PAR_TRIP_ID = "TripID";
    private static final String PAR_ESTTIME = "EstimatedTime";
    private static final String PAR_TOWARDS = "Towards";
    private static final String PAR_CIRCLE = "Circle";
    private static final Integer RES_TYPE_STOP = 0;
    private static final Integer RES_TYPE_PREDICTION = 1;
    private static final Integer RES_TYPE_URA_VERSION = 4;
    private static final String[] REQUEST_STOP = new String[]{"StopPointName", "StopID", "StopPointIndicator", "StopPointState", "Latitude,Longitude"};
    private static final String[] REQUEST_TRIP = new String[]{"StopPointName", "StopID", "StopPointIndicator", "StopPointState", "Latitude,Longitude", "VisitNumber", "LineID", "LineName", "DirectionID", "DestinationName", "DestinationText", "VehicleID", "TripID", "EstimatedTime"};
    private final String baseURL;
    private final String instantURL;
    private final String streamURL;
    private final ObjectMapper mapper;

    public UraClient(String baseURL) {
        this(baseURL, DEFAULT_INSTANT_URL, DEFAULT_STREAM_URL);
    }

    public UraClient(String baseURL, String instantURL, String streamURL) {
        this.baseURL = baseURL;
        this.instantURL = instantURL;
        this.streamURL = streamURL;
        this.mapper = new ObjectMapper();
    }

    public final Query forStops(String ... stops) {
        return new Query().forStops(stops);
    }

    public final Query forStopsByName(String ... stopNames) {
        return new Query().forStopsByName(stopNames);
    }

    public final Query forLines(String ... lines) {
        return new Query().forLines(lines);
    }

    public final Query forLinesByName(String ... lineNames) {
        return new Query().forLinesByName(lineNames);
    }

    public final Query forDirection(Integer direction) {
        return new Query().forDirection(direction);
    }

    public final Query forDestinationNames(String ... destinationNames) {
        return new Query().forDestinationNames(destinationNames);
    }

    public final Query towards(String ... towards) {
        return new Query().towards(towards);
    }

    public final Query forPosition(Double latitude, Double longitude, Integer radius) {
        return new Query().forPosition(latitude, longitude, radius);
    }

    public List<Trip> getTrips() {
        return this.getTrips(new Query(), null);
    }

    public List<Trip> getTrips(Integer limit) {
        return this.getTrips(new Query(), limit);
    }

    public List<Trip> getTrips(Query query) {
        return this.getTrips(query, null);
    }

    public List<Trip> getTrips(Query query, Integer limit) {
        ArrayList<Trip> trips = new ArrayList<Trip>();
        try (InputStream is = this.requestInstant(REQUEST_TRIP, query);
             BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String version = null;
            String line = br.readLine();
            while (line != null && (limit == null || trips.size() < limit)) {
                List l = (List)this.mapper.readValue(line, List.class);
                if (l != null && !l.isEmpty()) {
                    if (l.get(0).equals(RES_TYPE_URA_VERSION)) {
                        version = l.get(1).toString();
                    } else if (l.get(0).equals(RES_TYPE_PREDICTION)) {
                        trips.add(new Trip(l, version));
                    }
                }
                line = br.readLine();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read from API", e);
        }
        return trips;
    }

    public List<Stop> getStops() {
        return this.getStops(new Query());
    }

    public List<Stop> getStops(Query query) {
        ArrayList<Stop> stops = new ArrayList<Stop>();
        try (InputStream is = this.requestInstant(REQUEST_STOP, query);
             BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = br.readLine()) != null) {
                List l = (List)this.mapper.readValue(line, List.class);
                if (l == null || l.isEmpty() || !l.get(0).equals(RES_TYPE_STOP)) continue;
                stops.add(new Stop(l));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read from API", e);
        }
        return stops;
    }

    private InputStream requestInstant(String[] returnList, Query query) throws IOException {
        String urlStr = this.baseURL + this.instantURL + "?ReturnList=" + String.join((CharSequence)",", returnList);
        if (query.stopIDs != null && query.stopIDs.length > 0) {
            urlStr = urlStr + "&StopID=" + String.join((CharSequence)",", query.stopIDs);
        }
        if (query.stopNames != null && query.stopNames.length > 0) {
            urlStr = urlStr + "&StopPointName=" + String.join((CharSequence)",", query.stopNames);
        }
        if (query.lineIDs != null && query.lineIDs.length > 0) {
            urlStr = urlStr + "&LineID=" + String.join((CharSequence)",", query.lineIDs);
        }
        if (query.lineNames != null && query.lineNames.length > 0) {
            urlStr = urlStr + "&LineName=" + String.join((CharSequence)",", query.lineNames);
        }
        if (query.direction != null) {
            urlStr = urlStr + "&DirectionID=" + query.direction;
        }
        if (query.destinationNames != null) {
            urlStr = urlStr + "&DestinationName=" + String.join((CharSequence)",", query.destinationNames);
        }
        if (query.towards != null) {
            urlStr = urlStr + "&Towards=" + String.join((CharSequence)",", query.towards);
        }
        if (query.circle != null) {
            urlStr = urlStr + "&Circle=" + String.join((CharSequence)",", query.circle);
        }
        URL url = new URL(urlStr);
        return url.openStream();
    }

    public final class Query {
        private String[] stopIDs;
        private String[] stopNames;
        private String[] lineIDs;
        private String[] lineNames;
        private Integer direction;
        private String[] destinationNames;
        private String[] towards;
        private String circle;

        public Query forLines(String ... lineIDs) {
            this.lineIDs = lineIDs;
            return this;
        }

        public Query forLinesByName(String ... lineNames) {
            this.lineNames = lineNames;
            return this;
        }

        public Query forStops(String ... stopIDs) {
            this.stopIDs = stopIDs;
            return this;
        }

        public Query forStopsByName(String ... stopNames) {
            this.stopNames = stopNames;
            return this;
        }

        public Query forDirection(Integer direction) {
            this.direction = direction;
            return this;
        }

        public Query forDestinationNames(String ... destinationNames) {
            this.destinationNames = destinationNames;
            return this;
        }

        public Query towards(String ... towards) {
            this.towards = towards;
            return this;
        }

        public Query forPosition(Double latitude, Double longitude, Integer radius) {
            this.circle = latitude.toString() + "," + longitude.toString() + "," + radius.toString();
            return this;
        }

        public List<Stop> getStops() {
            return UraClient.this.getStops(this);
        }

        public List<Trip> getTrips() {
            return UraClient.this.getTrips(this);
        }
    }
}

