/*
 * Decompiled with CFR 0.152.
 */
package de.steffenrumpf;

import de.steffenrumpf.ExtendedDocument;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.asciidoctor.jruby.internal.JRubyAsciidoctor;

@Mojo(name="generate_blog_posts", defaultPhase=LifecyclePhase.PRE_SITE)
public class GenerateBlogPosts
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="index", required=true)
    private String outputFile;
    @Parameter
    private int pageSize = 0;
    private Path outDir = null;

    public void execute() throws MojoExecutionException {
        this.setOutDir(Paths.get(this.project.getBasedir() + File.separator + "generated_src" + File.separator + "site" + File.separator + "asciidoc", new String[0]));
        this.prepareOutputDir(this.outDir);
        try {
            File src = new File(this.project.getBasedir() + File.separator + "src" + File.separator + "site" + File.separator + "asciidoc");
            this.getLog().info((CharSequence)("Looking for .adoc files in " + src));
            List<ExtendedDocument> allDocuments = this.getAllFiles(src);
            this.getLog().info((CharSequence)"Sorting found files by side-date attribute.");
            Collections.sort(allDocuments);
            this.getLog().info((CharSequence)("Partition all documents." + this.pageSize + " posts per Page."));
            Map<Integer, List<ExtendedDocument>> list = this.partition(allDocuments, this.pageSize);
            this.getLog().info((CharSequence)("Partitioning into " + list.size() + " pages."));
            this.getLog().info((CharSequence)"Creating blog pages.");
            this.compile(list, this.outDir);
        }
        catch (Exception e1) {
            this.getLog().error((Throwable)e1);
        }
    }

    protected List<ExtendedDocument> getAllFiles(File folder) {
        ArrayList<ExtendedDocument> fileList = new ArrayList<ExtendedDocument>();
        if (folder.exists()) {
            for (File f : folder.listFiles()) {
                if (f.isDirectory()) {
                    fileList.addAll(this.getAllFiles(f));
                    continue;
                }
                if (!f.getName().endsWith(".adoc")) continue;
                this.getLog().info((CharSequence)("Found: " + f.getAbsolutePath()));
                JRubyAsciidoctor asciidoctor = JRubyAsciidoctor.create();
                HashMap options = new HashMap();
                ExtendedDocument document = new ExtendedDocument(asciidoctor.loadFile(f, options), f);
                fileList.add(document);
            }
        }
        return fileList;
    }

    private void compile(Map<Integer, List<ExtendedDocument>> list, Path outDir) throws FileExistsException {
        list.forEach((key, listOfDocuments) -> {
            try (FileWriterWithEncoding writer = new FileWriterWithEncoding(outDir.toAbsolutePath() + File.separator + this.outputFile + (key > 0 ? key : "") + ".adoc", "UTF-8");){
                StringBuffer output = new StringBuffer();
                if (this.pageSize > 0) {
                    output.append(this.createPagingString((int)key, list.size()));
                }
                for (ExtendedDocument doc : listOfDocuments) {
                    output.append(this.createBlogPost(doc.getFile()));
                    if (listOfDocuments.indexOf(doc) >= listOfDocuments.size() - 1) continue;
                    output.append("\n'''\n\n");
                }
                writer.write(output.toString());
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
            }
        });
    }

    protected String createBlogPost(File post) {
        StringBuffer output = new StringBuffer();
        output.append("\n");
        output.append("include::");
        output.append(this.getRelativePath(post));
        output.append("[]\n");
        return output.toString();
    }

    protected String createPagingString(int currentPage, int countPages) {
        StringBuffer returnSB = new StringBuffer();
        returnSB.append(":linkattrs: true\n\n");
        returnSB.append("[.pagination]\n");
        returnSB.append("--\n");
        for (int i = 0; i < countPages; ++i) {
            String filename = this.outputFile + i + ".html";
            String role = "";
            if (i == currentPage) {
                role = ", role=active";
            }
            if (i == 0) {
                filename = this.outputFile + ".html";
            }
            returnSB.append("link:" + filename + "[\"" + i + "\"" + role + "]\n");
        }
        returnSB.append("--\n");
        return returnSB.toString();
    }

    protected Map<Integer, List<ExtendedDocument>> partition(List<ExtendedDocument> list, int pageSize) {
        if (pageSize == 0) {
            HashMap<Integer, List<ExtendedDocument>> returnV = new HashMap<Integer, List<ExtendedDocument>>();
            returnV.put(pageSize, list);
            return returnV;
        }
        return IntStream.iterate(0, i -> i + pageSize).limit((list.size() + pageSize - 1) / pageSize).boxed().collect(Collectors.toMap(i -> i / pageSize, i -> list.subList((int)i, Math.min(i + pageSize, list.size()))));
    }

    protected void prepareOutputDir(Path folder) {
        try {
            FileUtils.deleteQuietly((File)folder.toFile());
            Files.createDirectories(folder, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
    }

    protected String getRelativePath(File file) {
        String path = file.getAbsolutePath();
        return path.replace(this.outDir.toString(), ".");
    }

    public Path getOutDir() {
        return this.outDir;
    }

    public void setOutDir(Path outDir) {
        this.outDir = outDir;
    }
}

