/*
 * Decompiled with CFR 0.152.
 */
package de.starwit.aic.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.starwit.aic.JSON;
import de.starwit.aic.model.AIModel;
import de.starwit.aic.model.ActionType;
import de.starwit.aic.model.DecisionType;
import de.starwit.aic.model.ModuleSBOMLocationValue;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Module {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    @Nullable
    private Long id;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    @Nullable
    private String version;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nullable
    private String name;
    public static final String SERIALIZED_NAME_APPLICATION_IDENTIFIER = "applicationIdentifier";
    @SerializedName(value="applicationIdentifier")
    @Nullable
    private String applicationIdentifier;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    @Nullable
    private String description;
    public static final String SERIALIZED_NAME_USE_A_I = "useAI";
    @SerializedName(value="useAI")
    @Nullable
    private Boolean useAI;
    public static final String SERIALIZED_NAME_MODEL = "model";
    @SerializedName(value="model")
    @Nullable
    private AIModel model;
    public static final String SERIALIZED_NAME_ACTION_TYPES = "actionTypes";
    @SerializedName(value="actionTypes")
    @Nullable
    private Set<ActionType> actionTypes = new LinkedHashSet<ActionType>();
    public static final String SERIALIZED_NAME_DECISION_TYPES = "decisionTypes";
    @SerializedName(value="decisionTypes")
    @Nullable
    private Set<DecisionType> decisionTypes = new LinkedHashSet<DecisionType>();
    public static final String SERIALIZED_NAME_S_B_O_M_LOCATION = "sBOMLocation";
    @SerializedName(value="sBOMLocation")
    @Nullable
    private Map<String, ModuleSBOMLocationValue> sBOMLocation = new HashMap<String, ModuleSBOMLocationValue>();
    public static final String SERIALIZED_NAME_SUCCESSORS = "successors";
    @SerializedName(value="successors")
    @Nullable
    private Set<Module> successors = new LinkedHashSet<Module>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Module id(@Nullable Long id) {
        this.id = id;
        return this;
    }

    @Nullable
    public Long getId() {
        return this.id;
    }

    public void setId(@Nullable Long id) {
        this.id = id;
    }

    public Module version(@Nullable String version) {
        this.version = version;
        return this;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    public Module name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public Module applicationIdentifier(@Nullable String applicationIdentifier) {
        this.applicationIdentifier = applicationIdentifier;
        return this;
    }

    @Nullable
    public String getApplicationIdentifier() {
        return this.applicationIdentifier;
    }

    public void setApplicationIdentifier(@Nullable String applicationIdentifier) {
        this.applicationIdentifier = applicationIdentifier;
    }

    public Module description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public Module useAI(@Nullable Boolean useAI) {
        this.useAI = useAI;
        return this;
    }

    @Nullable
    public Boolean getUseAI() {
        return this.useAI;
    }

    public void setUseAI(@Nullable Boolean useAI) {
        this.useAI = useAI;
    }

    public Module model(@Nullable AIModel model) {
        this.model = model;
        return this;
    }

    @Nullable
    public AIModel getModel() {
        return this.model;
    }

    public void setModel(@Nullable AIModel model) {
        this.model = model;
    }

    public Module actionTypes(@Nullable Set<ActionType> actionTypes) {
        this.actionTypes = actionTypes;
        return this;
    }

    public Module addActionTypesItem(ActionType actionTypesItem) {
        if (this.actionTypes == null) {
            this.actionTypes = new LinkedHashSet<ActionType>();
        }
        this.actionTypes.add(actionTypesItem);
        return this;
    }

    @Nullable
    public Set<ActionType> getActionTypes() {
        return this.actionTypes;
    }

    public void setActionTypes(@Nullable Set<ActionType> actionTypes) {
        this.actionTypes = actionTypes;
    }

    public Module decisionTypes(@Nullable Set<DecisionType> decisionTypes) {
        this.decisionTypes = decisionTypes;
        return this;
    }

    public Module addDecisionTypesItem(DecisionType decisionTypesItem) {
        if (this.decisionTypes == null) {
            this.decisionTypes = new LinkedHashSet<DecisionType>();
        }
        this.decisionTypes.add(decisionTypesItem);
        return this;
    }

    @Nullable
    public Set<DecisionType> getDecisionTypes() {
        return this.decisionTypes;
    }

    public void setDecisionTypes(@Nullable Set<DecisionType> decisionTypes) {
        this.decisionTypes = decisionTypes;
    }

    public Module sBOMLocation(@Nullable Map<String, ModuleSBOMLocationValue> sBOMLocation) {
        this.sBOMLocation = sBOMLocation;
        return this;
    }

    public Module putSBOMLocationItem(String key, ModuleSBOMLocationValue sBOMLocationItem) {
        if (this.sBOMLocation == null) {
            this.sBOMLocation = new HashMap<String, ModuleSBOMLocationValue>();
        }
        this.sBOMLocation.put(key, sBOMLocationItem);
        return this;
    }

    @Nullable
    public Map<String, ModuleSBOMLocationValue> getsBOMLocation() {
        return this.sBOMLocation;
    }

    public void setsBOMLocation(@Nullable Map<String, ModuleSBOMLocationValue> sBOMLocation) {
        this.sBOMLocation = sBOMLocation;
    }

    public Module successors(@Nullable Set<Module> successors) {
        this.successors = successors;
        return this;
    }

    public Module addSuccessorsItem(Module successorsItem) {
        if (this.successors == null) {
            this.successors = new LinkedHashSet<Module>();
        }
        this.successors.add(successorsItem);
        return this;
    }

    @Nullable
    public Set<Module> getSuccessors() {
        return this.successors;
    }

    public void setSuccessors(@Nullable Set<Module> successors) {
        this.successors = successors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Module module = (Module)o;
        return Objects.equals(this.id, module.id) && Objects.equals(this.version, module.version) && Objects.equals(this.name, module.name) && Objects.equals(this.applicationIdentifier, module.applicationIdentifier) && Objects.equals(this.description, module.description) && Objects.equals(this.useAI, module.useAI) && Objects.equals(this.model, module.model) && Objects.equals(this.actionTypes, module.actionTypes) && Objects.equals(this.decisionTypes, module.decisionTypes) && Objects.equals(this.sBOMLocation, module.sBOMLocation) && Objects.equals(this.successors, module.successors);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.name, this.applicationIdentifier, this.description, this.useAI, this.model, this.actionTypes, this.decisionTypes, this.sBOMLocation, this.successors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Module {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    applicationIdentifier: ").append(this.toIndentedString(this.applicationIdentifier)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    useAI: ").append(this.toIndentedString(this.useAI)).append("\n");
        sb.append("    model: ").append(this.toIndentedString(this.model)).append("\n");
        sb.append("    actionTypes: ").append(this.toIndentedString(this.actionTypes)).append("\n");
        sb.append("    decisionTypes: ").append(this.toIndentedString(this.decisionTypes)).append("\n");
        sb.append("    sBOMLocation: ").append(this.toIndentedString(this.sBOMLocation)).append("\n");
        sb.append("    successors: ").append(this.toIndentedString(this.successors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraysuccessors;
        JsonArray jsonArraydecisionTypes;
        int i;
        JsonArray jsonArrayactionTypes;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Module is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Module` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `version` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPLICATION_IDENTIFIER) != null && !jsonObj.get(SERIALIZED_NAME_APPLICATION_IDENTIFIER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_APPLICATION_IDENTIFIER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `applicationIdentifier` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPLICATION_IDENTIFIER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MODEL) != null && !jsonObj.get(SERIALIZED_NAME_MODEL).isJsonNull()) {
            AIModel.validateJsonElement(jsonObj.get(SERIALIZED_NAME_MODEL));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACTION_TYPES) != null && !jsonObj.get(SERIALIZED_NAME_ACTION_TYPES).isJsonNull() && (jsonArrayactionTypes = jsonObj.getAsJsonArray(SERIALIZED_NAME_ACTION_TYPES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ACTION_TYPES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `actionTypes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTION_TYPES).toString()));
            }
            for (i = 0; i < jsonArrayactionTypes.size(); ++i) {
                ActionType.validateJsonElement(jsonArrayactionTypes.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DECISION_TYPES) != null && !jsonObj.get(SERIALIZED_NAME_DECISION_TYPES).isJsonNull() && (jsonArraydecisionTypes = jsonObj.getAsJsonArray(SERIALIZED_NAME_DECISION_TYPES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DECISION_TYPES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `decisionTypes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DECISION_TYPES).toString()));
            }
            for (i = 0; i < jsonArraydecisionTypes.size(); ++i) {
                DecisionType.validateJsonElement(jsonArraydecisionTypes.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SUCCESSORS) != null && !jsonObj.get(SERIALIZED_NAME_SUCCESSORS).isJsonNull() && (jsonArraysuccessors = jsonObj.getAsJsonArray(SERIALIZED_NAME_SUCCESSORS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SUCCESSORS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `successors` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUCCESSORS).toString()));
            }
            for (i = 0; i < jsonArraysuccessors.size(); ++i) {
                Module.validateJsonElement(jsonArraysuccessors.get(i));
            }
        }
    }

    public static Module fromJson(String jsonString) throws IOException {
        return (Module)JSON.getGson().fromJson(jsonString, Module.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_APPLICATION_IDENTIFIER);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_USE_A_I);
        openapiFields.add(SERIALIZED_NAME_MODEL);
        openapiFields.add(SERIALIZED_NAME_ACTION_TYPES);
        openapiFields.add(SERIALIZED_NAME_DECISION_TYPES);
        openapiFields.add(SERIALIZED_NAME_S_B_O_M_LOCATION);
        openapiFields.add(SERIALIZED_NAME_SUCCESSORS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Module.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Module.class));
            return new TypeAdapter<Module>(this){

                public void write(JsonWriter out, Module value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Module read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Module.validateJsonElement(jsonElement);
                    return (Module)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

