/*
 * Decompiled with CFR 0.152.
 */
package de.starwit.aic.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.starwit.aic.JSON;
import de.starwit.aic.model.Action;
import de.starwit.aic.model.DecisionType;
import de.starwit.aic.model.Module;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Decision {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private Long id;
    public static final String SERIALIZED_NAME_ACQUISITION_TIME = "acquisitionTime";
    @SerializedName(value="acquisitionTime")
    private OffsetDateTime acquisitionTime;
    public static final String SERIALIZED_NAME_MEDIA_URL = "mediaUrl";
    @SerializedName(value="mediaUrl")
    private String mediaUrl;
    public static final String SERIALIZED_NAME_ACTION_VISUALIZATION_URL = "actionVisualizationUrl";
    @SerializedName(value="actionVisualizationUrl")
    private String actionVisualizationUrl;
    public static final String SERIALIZED_NAME_CAMERA_LATITUDE = "cameraLatitude";
    @SerializedName(value="cameraLatitude")
    private BigDecimal cameraLatitude;
    public static final String SERIALIZED_NAME_CAMERA_LONGITUDE = "cameraLongitude";
    @SerializedName(value="cameraLongitude")
    private BigDecimal cameraLongitude;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_MODULE = "module";
    @SerializedName(value="module")
    private Module module;
    public static final String SERIALIZED_NAME_DECISION_TYPE = "decisionType";
    @SerializedName(value="decisionType")
    private DecisionType decisionType;
    public static final String SERIALIZED_NAME_ACTIONS = "actions";
    @SerializedName(value="actions")
    private Set<Action> actions;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Decision id(Long id) {
        this.id = id;
        return this;
    }

    @Nullable
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Decision acquisitionTime(OffsetDateTime acquisitionTime) {
        this.acquisitionTime = acquisitionTime;
        return this;
    }

    @Nullable
    public OffsetDateTime getAcquisitionTime() {
        return this.acquisitionTime;
    }

    public void setAcquisitionTime(OffsetDateTime acquisitionTime) {
        this.acquisitionTime = acquisitionTime;
    }

    public Decision mediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    @Nullable
    public String getMediaUrl() {
        return this.mediaUrl;
    }

    public void setMediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
    }

    public Decision actionVisualizationUrl(String actionVisualizationUrl) {
        this.actionVisualizationUrl = actionVisualizationUrl;
        return this;
    }

    @Nullable
    public String getActionVisualizationUrl() {
        return this.actionVisualizationUrl;
    }

    public void setActionVisualizationUrl(String actionVisualizationUrl) {
        this.actionVisualizationUrl = actionVisualizationUrl;
    }

    public Decision cameraLatitude(BigDecimal cameraLatitude) {
        this.cameraLatitude = cameraLatitude;
        return this;
    }

    @Nullable
    public BigDecimal getCameraLatitude() {
        return this.cameraLatitude;
    }

    public void setCameraLatitude(BigDecimal cameraLatitude) {
        this.cameraLatitude = cameraLatitude;
    }

    public Decision cameraLongitude(BigDecimal cameraLongitude) {
        this.cameraLongitude = cameraLongitude;
        return this;
    }

    @Nullable
    public BigDecimal getCameraLongitude() {
        return this.cameraLongitude;
    }

    public void setCameraLongitude(BigDecimal cameraLongitude) {
        this.cameraLongitude = cameraLongitude;
    }

    public Decision state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public Decision description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Decision module(Module module) {
        this.module = module;
        return this;
    }

    @Nullable
    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public Decision decisionType(DecisionType decisionType) {
        this.decisionType = decisionType;
        return this;
    }

    @Nullable
    public DecisionType getDecisionType() {
        return this.decisionType;
    }

    public void setDecisionType(DecisionType decisionType) {
        this.decisionType = decisionType;
    }

    public Decision actions(Set<Action> actions) {
        this.actions = actions;
        return this;
    }

    public Decision addActionsItem(Action actionsItem) {
        if (this.actions == null) {
            this.actions = new LinkedHashSet<Action>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @Nullable
    public Set<Action> getActions() {
        return this.actions;
    }

    public void setActions(Set<Action> actions) {
        this.actions = actions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Decision decision = (Decision)o;
        return Objects.equals(this.id, decision.id) && Objects.equals(this.acquisitionTime, decision.acquisitionTime) && Objects.equals(this.mediaUrl, decision.mediaUrl) && Objects.equals(this.actionVisualizationUrl, decision.actionVisualizationUrl) && Objects.equals(this.cameraLatitude, decision.cameraLatitude) && Objects.equals(this.cameraLongitude, decision.cameraLongitude) && Objects.equals((Object)this.state, (Object)decision.state) && Objects.equals(this.description, decision.description) && Objects.equals(this.module, decision.module) && Objects.equals(this.decisionType, decision.decisionType) && Objects.equals(this.actions, decision.actions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.acquisitionTime, this.mediaUrl, this.actionVisualizationUrl, this.cameraLatitude, this.cameraLongitude, this.state, this.description, this.module, this.decisionType, this.actions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Decision {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    acquisitionTime: ").append(this.toIndentedString(this.acquisitionTime)).append("\n");
        sb.append("    mediaUrl: ").append(this.toIndentedString(this.mediaUrl)).append("\n");
        sb.append("    actionVisualizationUrl: ").append(this.toIndentedString(this.actionVisualizationUrl)).append("\n");
        sb.append("    cameraLatitude: ").append(this.toIndentedString(this.cameraLatitude)).append("\n");
        sb.append("    cameraLongitude: ").append(this.toIndentedString(this.cameraLongitude)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    module: ").append(this.toIndentedString(this.module)).append("\n");
        sb.append("    decisionType: ").append(this.toIndentedString(this.decisionType)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayactions;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Decision is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Decision` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_MEDIA_URL) != null && !jsonObj.get(SERIALIZED_NAME_MEDIA_URL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MEDIA_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mediaUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MEDIA_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACTION_VISUALIZATION_URL) != null && !jsonObj.get(SERIALIZED_NAME_ACTION_VISUALIZATION_URL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACTION_VISUALIZATION_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `actionVisualizationUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTION_VISUALIZATION_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATE) != null && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `state` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATE) != null && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonNull()) {
            StateEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATE));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MODULE) != null && !jsonObj.get(SERIALIZED_NAME_MODULE).isJsonNull()) {
            Module.validateJsonElement(jsonObj.get(SERIALIZED_NAME_MODULE));
        }
        if (jsonObj.get(SERIALIZED_NAME_DECISION_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_DECISION_TYPE).isJsonNull()) {
            DecisionType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DECISION_TYPE));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACTIONS) != null && !jsonObj.get(SERIALIZED_NAME_ACTIONS).isJsonNull() && (jsonArrayactions = jsonObj.getAsJsonArray(SERIALIZED_NAME_ACTIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ACTIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `actions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTIONS).toString()));
            }
            for (int i = 0; i < jsonArrayactions.size(); ++i) {
                Action.validateJsonElement(jsonArrayactions.get(i));
            }
        }
    }

    public static Decision fromJson(String jsonString) throws IOException {
        return (Decision)JSON.getGson().fromJson(jsonString, Decision.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ACQUISITION_TIME);
        openapiFields.add(SERIALIZED_NAME_MEDIA_URL);
        openapiFields.add(SERIALIZED_NAME_ACTION_VISUALIZATION_URL);
        openapiFields.add(SERIALIZED_NAME_CAMERA_LATITUDE);
        openapiFields.add(SERIALIZED_NAME_CAMERA_LONGITUDE);
        openapiFields.add(SERIALIZED_NAME_STATE);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_MODULE);
        openapiFields.add(SERIALIZED_NAME_DECISION_TYPE);
        openapiFields.add(SERIALIZED_NAME_ACTIONS);
        openapiRequiredFields = new HashSet();
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        NEW("NEW"),
        ACCEPTED("ACCEPTED"),
        REJECTED("REJECTED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            StateEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Decision.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Decision.class));
            return new TypeAdapter<Decision>(this){

                public void write(JsonWriter out, Decision value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Decision read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Decision.validateJsonElement(jsonElement);
                    return (Decision)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

