/*
 * AI Cockpit Decisions
 * This API is part of project AI cockpit.   For more details see: https://www.kicockpit.eu/ 
 *
 * The version of the OpenAPI document: 0.0.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.starwit.aic.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.starwit.aic.model.AIModel;
import de.starwit.aic.model.ActionType;
import de.starwit.aic.model.DecisionType;
import de.starwit.aic.model.ModuleSBOMLocationValue;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import de.starwit.aic.JSON;

/**
 * Module
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-04-22T10:02:22.174100061+02:00[Europe/Berlin]")
public class Module {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_VERSION = "version";
  @SerializedName(SERIALIZED_NAME_VERSION)
  private String version;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_APPLICATION_IDENTIFIER = "applicationIdentifier";
  @SerializedName(SERIALIZED_NAME_APPLICATION_IDENTIFIER)
  private String applicationIdentifier;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_USE_A_I = "useAI";
  @SerializedName(SERIALIZED_NAME_USE_A_I)
  private Boolean useAI;

  public static final String SERIALIZED_NAME_MODEL = "model";
  @SerializedName(SERIALIZED_NAME_MODEL)
  private AIModel model;

  public static final String SERIALIZED_NAME_ACTION_TYPES = "actionTypes";
  @SerializedName(SERIALIZED_NAME_ACTION_TYPES)
  private Set<ActionType> actionTypes;

  public static final String SERIALIZED_NAME_DECISION_TYPES = "decisionTypes";
  @SerializedName(SERIALIZED_NAME_DECISION_TYPES)
  private Set<DecisionType> decisionTypes;

  public static final String SERIALIZED_NAME_S_B_O_M_LOCATION = "sBOMLocation";
  @SerializedName(SERIALIZED_NAME_S_B_O_M_LOCATION)
  private Map<String, ModuleSBOMLocationValue> sBOMLocation = new HashMap<>();

  public static final String SERIALIZED_NAME_SUCCESSORS = "successors";
  @SerializedName(SERIALIZED_NAME_SUCCESSORS)
  private Set<Module> successors;

  public Module() {
  }

  public Module id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nullable
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }


  public Module version(String version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @jakarta.annotation.Nullable
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }


  public Module name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @jakarta.annotation.Nullable
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  public Module applicationIdentifier(String applicationIdentifier) {
    this.applicationIdentifier = applicationIdentifier;
    return this;
  }

   /**
   * Get applicationIdentifier
   * @return applicationIdentifier
  **/
  @jakarta.annotation.Nullable
  public String getApplicationIdentifier() {
    return applicationIdentifier;
  }

  public void setApplicationIdentifier(String applicationIdentifier) {
    this.applicationIdentifier = applicationIdentifier;
  }


  public Module description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @jakarta.annotation.Nullable
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }


  public Module useAI(Boolean useAI) {
    this.useAI = useAI;
    return this;
  }

   /**
   * Get useAI
   * @return useAI
  **/
  @jakarta.annotation.Nullable
  public Boolean getUseAI() {
    return useAI;
  }

  public void setUseAI(Boolean useAI) {
    this.useAI = useAI;
  }


  public Module model(AIModel model) {
    this.model = model;
    return this;
  }

   /**
   * Get model
   * @return model
  **/
  @jakarta.annotation.Nullable
  public AIModel getModel() {
    return model;
  }

  public void setModel(AIModel model) {
    this.model = model;
  }


  public Module actionTypes(Set<ActionType> actionTypes) {
    this.actionTypes = actionTypes;
    return this;
  }

  public Module addActionTypesItem(ActionType actionTypesItem) {
    if (this.actionTypes == null) {
      this.actionTypes = new LinkedHashSet<>();
    }
    this.actionTypes.add(actionTypesItem);
    return this;
  }

   /**
   * Get actionTypes
   * @return actionTypes
  **/
  @jakarta.annotation.Nullable
  public Set<ActionType> getActionTypes() {
    return actionTypes;
  }

  public void setActionTypes(Set<ActionType> actionTypes) {
    this.actionTypes = actionTypes;
  }


  public Module decisionTypes(Set<DecisionType> decisionTypes) {
    this.decisionTypes = decisionTypes;
    return this;
  }

  public Module addDecisionTypesItem(DecisionType decisionTypesItem) {
    if (this.decisionTypes == null) {
      this.decisionTypes = new LinkedHashSet<>();
    }
    this.decisionTypes.add(decisionTypesItem);
    return this;
  }

   /**
   * Get decisionTypes
   * @return decisionTypes
  **/
  @jakarta.annotation.Nullable
  public Set<DecisionType> getDecisionTypes() {
    return decisionTypes;
  }

  public void setDecisionTypes(Set<DecisionType> decisionTypes) {
    this.decisionTypes = decisionTypes;
  }


  public Module sBOMLocation(Map<String, ModuleSBOMLocationValue> sBOMLocation) {
    this.sBOMLocation = sBOMLocation;
    return this;
  }

  public Module putSBOMLocationItem(String key, ModuleSBOMLocationValue sBOMLocationItem) {
    if (this.sBOMLocation == null) {
      this.sBOMLocation = new HashMap<>();
    }
    this.sBOMLocation.put(key, sBOMLocationItem);
    return this;
  }

   /**
   * Get sBOMLocation
   * @return sBOMLocation
  **/
  @jakarta.annotation.Nullable
  public Map<String, ModuleSBOMLocationValue> getsBOMLocation() {
    return sBOMLocation;
  }

  public void setsBOMLocation(Map<String, ModuleSBOMLocationValue> sBOMLocation) {
    this.sBOMLocation = sBOMLocation;
  }


  public Module successors(Set<Module> successors) {
    this.successors = successors;
    return this;
  }

  public Module addSuccessorsItem(Module successorsItem) {
    if (this.successors == null) {
      this.successors = new LinkedHashSet<>();
    }
    this.successors.add(successorsItem);
    return this;
  }

   /**
   * Get successors
   * @return successors
  **/
  @jakarta.annotation.Nullable
  public Set<Module> getSuccessors() {
    return successors;
  }

  public void setSuccessors(Set<Module> successors) {
    this.successors = successors;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Module module = (Module) o;
    return Objects.equals(this.id, module.id) &&
        Objects.equals(this.version, module.version) &&
        Objects.equals(this.name, module.name) &&
        Objects.equals(this.applicationIdentifier, module.applicationIdentifier) &&
        Objects.equals(this.description, module.description) &&
        Objects.equals(this.useAI, module.useAI) &&
        Objects.equals(this.model, module.model) &&
        Objects.equals(this.actionTypes, module.actionTypes) &&
        Objects.equals(this.decisionTypes, module.decisionTypes) &&
        Objects.equals(this.sBOMLocation, module.sBOMLocation) &&
        Objects.equals(this.successors, module.successors);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, version, name, applicationIdentifier, description, useAI, model, actionTypes, decisionTypes, sBOMLocation, successors);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Module {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    applicationIdentifier: ").append(toIndentedString(applicationIdentifier)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    useAI: ").append(toIndentedString(useAI)).append("\n");
    sb.append("    model: ").append(toIndentedString(model)).append("\n");
    sb.append("    actionTypes: ").append(toIndentedString(actionTypes)).append("\n");
    sb.append("    decisionTypes: ").append(toIndentedString(decisionTypes)).append("\n");
    sb.append("    sBOMLocation: ").append(toIndentedString(sBOMLocation)).append("\n");
    sb.append("    successors: ").append(toIndentedString(successors)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("version");
    openapiFields.add("name");
    openapiFields.add("applicationIdentifier");
    openapiFields.add("description");
    openapiFields.add("useAI");
    openapiFields.add("model");
    openapiFields.add("actionTypes");
    openapiFields.add("decisionTypes");
    openapiFields.add("sBOMLocation");
    openapiFields.add("successors");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Element and throws an exception if issues found
  *
  * @param jsonElement JSON Element
  * @throws IOException if the JSON Element is invalid with respect to Module
  */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!Module.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Module is not found in the empty JSON string", Module.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Module.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Module` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("version") != null && !jsonObj.get("version").isJsonNull()) && !jsonObj.get("version").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `version` to be a primitive type in the JSON string but got `%s`", jsonObj.get("version").toString()));
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("applicationIdentifier") != null && !jsonObj.get("applicationIdentifier").isJsonNull()) && !jsonObj.get("applicationIdentifier").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `applicationIdentifier` to be a primitive type in the JSON string but got `%s`", jsonObj.get("applicationIdentifier").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      // validate the optional field `model`
      if (jsonObj.get("model") != null && !jsonObj.get("model").isJsonNull()) {
        AIModel.validateJsonElement(jsonObj.get("model"));
      }
      if (jsonObj.get("actionTypes") != null && !jsonObj.get("actionTypes").isJsonNull()) {
        JsonArray jsonArrayactionTypes = jsonObj.getAsJsonArray("actionTypes");
        if (jsonArrayactionTypes != null) {
          // ensure the json data is an array
          if (!jsonObj.get("actionTypes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `actionTypes` to be an array in the JSON string but got `%s`", jsonObj.get("actionTypes").toString()));
          }

          // validate the optional field `actionTypes` (array)
          for (int i = 0; i < jsonArrayactionTypes.size(); i++) {
            ActionType.validateJsonElement(jsonArrayactionTypes.get(i));
          };
        }
      }
      if (jsonObj.get("decisionTypes") != null && !jsonObj.get("decisionTypes").isJsonNull()) {
        JsonArray jsonArraydecisionTypes = jsonObj.getAsJsonArray("decisionTypes");
        if (jsonArraydecisionTypes != null) {
          // ensure the json data is an array
          if (!jsonObj.get("decisionTypes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `decisionTypes` to be an array in the JSON string but got `%s`", jsonObj.get("decisionTypes").toString()));
          }

          // validate the optional field `decisionTypes` (array)
          for (int i = 0; i < jsonArraydecisionTypes.size(); i++) {
            DecisionType.validateJsonElement(jsonArraydecisionTypes.get(i));
          };
        }
      }
      if (jsonObj.get("successors") != null && !jsonObj.get("successors").isJsonNull()) {
        JsonArray jsonArraysuccessors = jsonObj.getAsJsonArray("successors");
        if (jsonArraysuccessors != null) {
          // ensure the json data is an array
          if (!jsonObj.get("successors").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `successors` to be an array in the JSON string but got `%s`", jsonObj.get("successors").toString()));
          }

          // validate the optional field `successors` (array)
          for (int i = 0; i < jsonArraysuccessors.size(); i++) {
            Module.validateJsonElement(jsonArraysuccessors.get(i));
          };
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Module.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Module' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Module> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Module.class));

       return (TypeAdapter<T>) new TypeAdapter<Module>() {
           @Override
           public void write(JsonWriter out, Module value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Module read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Module given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Module
  * @throws IOException if the JSON string is invalid with respect to Module
  */
  public static Module fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Module.class);
  }

 /**
  * Convert an instance of Module to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

