/*
 * AI Cockpit Decisions
 * This API is part of project AI cockpit.   For more details see: https://www.kicockpit.eu/ 
 *
 * The version of the OpenAPI document: 0.0.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.starwit.aic.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.starwit.aic.model.AIModelType;
import java.io.IOException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import de.starwit.aic.JSON;

/**
 * AIModel
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-04-22T10:02:22.174100061+02:00[Europe/Berlin]")
public class AIModel {
  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_VERSION = "version";
  @SerializedName(SERIALIZED_NAME_VERSION)
  private String version;

  public static final String SERIALIZED_NAME_LAST_DEPLOYMENT = "lastDeployment";
  @SerializedName(SERIALIZED_NAME_LAST_DEPLOYMENT)
  private OffsetDateTime lastDeployment;

  public static final String SERIALIZED_NAME_MODEL_TYPE = "modelType";
  @SerializedName(SERIALIZED_NAME_MODEL_TYPE)
  private AIModelType modelType;

  public static final String SERIALIZED_NAME_MODEL_LINK = "modelLink";
  @SerializedName(SERIALIZED_NAME_MODEL_LINK)
  private URI modelLink;

  public static final String SERIALIZED_NAME_PUBLIC_TRAINING_DATA = "publicTrainingData";
  @SerializedName(SERIALIZED_NAME_PUBLIC_TRAINING_DATA)
  private Boolean publicTrainingData;

  public static final String SERIALIZED_NAME_LINK_TO_PUBLIC_TRAINING_DATA = "linkToPublicTrainingData";
  @SerializedName(SERIALIZED_NAME_LINK_TO_PUBLIC_TRAINING_DATA)
  private URI linkToPublicTrainingData;

  public AIModel() {
  }

  public AIModel name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @jakarta.annotation.Nullable
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  public AIModel version(String version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @jakarta.annotation.Nullable
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }


  public AIModel lastDeployment(OffsetDateTime lastDeployment) {
    this.lastDeployment = lastDeployment;
    return this;
  }

   /**
   * Get lastDeployment
   * @return lastDeployment
  **/
  @jakarta.annotation.Nullable
  public OffsetDateTime getLastDeployment() {
    return lastDeployment;
  }

  public void setLastDeployment(OffsetDateTime lastDeployment) {
    this.lastDeployment = lastDeployment;
  }


  public AIModel modelType(AIModelType modelType) {
    this.modelType = modelType;
    return this;
  }

   /**
   * Get modelType
   * @return modelType
  **/
  @jakarta.annotation.Nullable
  public AIModelType getModelType() {
    return modelType;
  }

  public void setModelType(AIModelType modelType) {
    this.modelType = modelType;
  }


  public AIModel modelLink(URI modelLink) {
    this.modelLink = modelLink;
    return this;
  }

   /**
   * Link to model documentation
   * @return modelLink
  **/
  @jakarta.annotation.Nullable
  public URI getModelLink() {
    return modelLink;
  }

  public void setModelLink(URI modelLink) {
    this.modelLink = modelLink;
  }


  public AIModel publicTrainingData(Boolean publicTrainingData) {
    this.publicTrainingData = publicTrainingData;
    return this;
  }

   /**
   * Is model based on public training data?
   * @return publicTrainingData
  **/
  @jakarta.annotation.Nullable
  public Boolean getPublicTrainingData() {
    return publicTrainingData;
  }

  public void setPublicTrainingData(Boolean publicTrainingData) {
    this.publicTrainingData = publicTrainingData;
  }


  public AIModel linkToPublicTrainingData(URI linkToPublicTrainingData) {
    this.linkToPublicTrainingData = linkToPublicTrainingData;
    return this;
  }

   /**
   * Link to public training data / documentation.
   * @return linkToPublicTrainingData
  **/
  @jakarta.annotation.Nullable
  public URI getLinkToPublicTrainingData() {
    return linkToPublicTrainingData;
  }

  public void setLinkToPublicTrainingData(URI linkToPublicTrainingData) {
    this.linkToPublicTrainingData = linkToPublicTrainingData;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AIModel aiModel = (AIModel) o;
    return Objects.equals(this.name, aiModel.name) &&
        Objects.equals(this.version, aiModel.version) &&
        Objects.equals(this.lastDeployment, aiModel.lastDeployment) &&
        Objects.equals(this.modelType, aiModel.modelType) &&
        Objects.equals(this.modelLink, aiModel.modelLink) &&
        Objects.equals(this.publicTrainingData, aiModel.publicTrainingData) &&
        Objects.equals(this.linkToPublicTrainingData, aiModel.linkToPublicTrainingData);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, version, lastDeployment, modelType, modelLink, publicTrainingData, linkToPublicTrainingData);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AIModel {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    lastDeployment: ").append(toIndentedString(lastDeployment)).append("\n");
    sb.append("    modelType: ").append(toIndentedString(modelType)).append("\n");
    sb.append("    modelLink: ").append(toIndentedString(modelLink)).append("\n");
    sb.append("    publicTrainingData: ").append(toIndentedString(publicTrainingData)).append("\n");
    sb.append("    linkToPublicTrainingData: ").append(toIndentedString(linkToPublicTrainingData)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("name");
    openapiFields.add("version");
    openapiFields.add("lastDeployment");
    openapiFields.add("modelType");
    openapiFields.add("modelLink");
    openapiFields.add("publicTrainingData");
    openapiFields.add("linkToPublicTrainingData");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Element and throws an exception if issues found
  *
  * @param jsonElement JSON Element
  * @throws IOException if the JSON Element is invalid with respect to AIModel
  */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!AIModel.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in AIModel is not found in the empty JSON string", AIModel.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!AIModel.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AIModel` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("version") != null && !jsonObj.get("version").isJsonNull()) && !jsonObj.get("version").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `version` to be a primitive type in the JSON string but got `%s`", jsonObj.get("version").toString()));
      }
      // validate the optional field `modelType`
      if (jsonObj.get("modelType") != null && !jsonObj.get("modelType").isJsonNull()) {
        AIModelType.validateJsonElement(jsonObj.get("modelType"));
      }
      if ((jsonObj.get("modelLink") != null && !jsonObj.get("modelLink").isJsonNull()) && !jsonObj.get("modelLink").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `modelLink` to be a primitive type in the JSON string but got `%s`", jsonObj.get("modelLink").toString()));
      }
      if ((jsonObj.get("linkToPublicTrainingData") != null && !jsonObj.get("linkToPublicTrainingData").isJsonNull()) && !jsonObj.get("linkToPublicTrainingData").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `linkToPublicTrainingData` to be a primitive type in the JSON string but got `%s`", jsonObj.get("linkToPublicTrainingData").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!AIModel.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'AIModel' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<AIModel> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(AIModel.class));

       return (TypeAdapter<T>) new TypeAdapter<AIModel>() {
           @Override
           public void write(JsonWriter out, AIModel value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public AIModel read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of AIModel given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of AIModel
  * @throws IOException if the JSON string is invalid with respect to AIModel
  */
  public static AIModel fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, AIModel.class);
  }

 /**
  * Convert an instance of AIModel to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

