/*
 * Decompiled with CFR 0.152.
 */
package de.starwit.aic.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.starwit.aic.JSON;
import de.starwit.aic.model.ModelType;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Model {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private String version;
    public static final String SERIALIZED_NAME_LAST_DEPLOYMENT = "lastDeployment";
    @SerializedName(value="lastDeployment")
    private OffsetDateTime lastDeployment;
    public static final String SERIALIZED_NAME_MODEL_TYPE = "modelType";
    @SerializedName(value="modelType")
    private ModelType modelType;
    public static final String SERIALIZED_NAME_MODEL_LINK = "modelLink";
    @SerializedName(value="modelLink")
    private URI modelLink;
    public static final String SERIALIZED_NAME_PUBLIC_TRAINING_DATA = "publicTrainingData";
    @SerializedName(value="publicTrainingData")
    private Boolean publicTrainingData;
    public static final String SERIALIZED_NAME_LINK_TO_PUBLIC_TRAINING_DATA = "linkToPublicTrainingData";
    @SerializedName(value="linkToPublicTrainingData")
    private URI linkToPublicTrainingData;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Model name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Model version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Model lastDeployment(OffsetDateTime lastDeployment) {
        this.lastDeployment = lastDeployment;
        return this;
    }

    @Nullable
    public OffsetDateTime getLastDeployment() {
        return this.lastDeployment;
    }

    public void setLastDeployment(OffsetDateTime lastDeployment) {
        this.lastDeployment = lastDeployment;
    }

    public Model modelType(ModelType modelType) {
        this.modelType = modelType;
        return this;
    }

    @Nullable
    public ModelType getModelType() {
        return this.modelType;
    }

    public void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    public Model modelLink(URI modelLink) {
        this.modelLink = modelLink;
        return this;
    }

    @Nullable
    public URI getModelLink() {
        return this.modelLink;
    }

    public void setModelLink(URI modelLink) {
        this.modelLink = modelLink;
    }

    public Model publicTrainingData(Boolean publicTrainingData) {
        this.publicTrainingData = publicTrainingData;
        return this;
    }

    @Nullable
    public Boolean getPublicTrainingData() {
        return this.publicTrainingData;
    }

    public void setPublicTrainingData(Boolean publicTrainingData) {
        this.publicTrainingData = publicTrainingData;
    }

    public Model linkToPublicTrainingData(URI linkToPublicTrainingData) {
        this.linkToPublicTrainingData = linkToPublicTrainingData;
        return this;
    }

    @Nullable
    public URI getLinkToPublicTrainingData() {
        return this.linkToPublicTrainingData;
    }

    public void setLinkToPublicTrainingData(URI linkToPublicTrainingData) {
        this.linkToPublicTrainingData = linkToPublicTrainingData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Model model = (Model)o;
        return Objects.equals(this.name, model.name) && Objects.equals(this.version, model.version) && Objects.equals(this.lastDeployment, model.lastDeployment) && Objects.equals((Object)this.modelType, (Object)model.modelType) && Objects.equals(this.modelLink, model.modelLink) && Objects.equals(this.publicTrainingData, model.publicTrainingData) && Objects.equals(this.linkToPublicTrainingData, model.linkToPublicTrainingData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.version, this.lastDeployment, this.modelType, this.modelLink, this.publicTrainingData, this.linkToPublicTrainingData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Model {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    lastDeployment: ").append(this.toIndentedString(this.lastDeployment)).append("\n");
        sb.append("    modelType: ").append(this.toIndentedString((Object)this.modelType)).append("\n");
        sb.append("    modelLink: ").append(this.toIndentedString(this.modelLink)).append("\n");
        sb.append("    publicTrainingData: ").append(this.toIndentedString(this.publicTrainingData)).append("\n");
        sb.append("    linkToPublicTrainingData: ").append(this.toIndentedString(this.linkToPublicTrainingData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Model is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Model` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `version` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MODEL_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_MODEL_TYPE).isJsonNull()) {
            ModelType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_MODEL_TYPE));
        }
        if (jsonObj.get(SERIALIZED_NAME_MODEL_LINK) != null && !jsonObj.get(SERIALIZED_NAME_MODEL_LINK).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MODEL_LINK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `modelLink` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MODEL_LINK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LINK_TO_PUBLIC_TRAINING_DATA) != null && !jsonObj.get(SERIALIZED_NAME_LINK_TO_PUBLIC_TRAINING_DATA).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LINK_TO_PUBLIC_TRAINING_DATA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `linkToPublicTrainingData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LINK_TO_PUBLIC_TRAINING_DATA).toString()));
        }
    }

    public static Model fromJson(String jsonString) throws IOException {
        return (Model)JSON.getGson().fromJson(jsonString, Model.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_LAST_DEPLOYMENT);
        openapiFields.add(SERIALIZED_NAME_MODEL_TYPE);
        openapiFields.add(SERIALIZED_NAME_MODEL_LINK);
        openapiFields.add(SERIALIZED_NAME_PUBLIC_TRAINING_DATA);
        openapiFields.add(SERIALIZED_NAME_LINK_TO_PUBLIC_TRAINING_DATA);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Model.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Model.class));
            return new TypeAdapter<Model>(this){

                public void write(JsonWriter out, Model value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Model read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Model.validateJsonElement(jsonElement);
                    return (Model)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

