/*
 * Decompiled with CFR 0.152.
 */
package de.starwit.auth.userdata;

import de.starwit.auth.userdata.ConfigData;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDirectoryDataRequester {
    private DirContext ctx;
    private final ConfigData configData = ConfigData.getInstance();
    Logger log = Logger.getLogger(UserDirectoryDataRequester.class);

    public UserDirectoryDataRequester(DirContext context) {
        this.ctx = context;
    }

    public Map<String, String> getUserData(String loggedInUser) {
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        sc.setReturningObjFlag(true);
        String base = this.configData.getProperty("directory.basepath");
        String filter = this.configData.getProperty("directory.searchFilter");
        filter = filter.replaceAll("###USER_NAME###", loggedInUser);
        try {
            NamingEnumeration<SearchResult> results = this.ctx.search(base, filter, sc);
            Map<String, String> userData = this.extractUserData(results);
            return userData;
        }
        catch (NamingException e) {
            this.log.error((Object)("try to query user directory, returned empty data set. Filter used: " + filter));
            return new HashMap<String, String>();
        }
    }

    private Map<String, String> extractUserData(NamingEnumeration<SearchResult> searchResults) {
        HashMap<String, String> result = new HashMap<String, String>();
        while (searchResults.hasMoreElements()) {
            SearchResult sr = (SearchResult)searchResults.nextElement();
            Attributes attrs = sr.getAttributes();
            for (String attrName : ConfigData.getInstance().getAttributeNames()) {
                Attribute attr = attrs.get(attrName);
                String value = "";
                if (attr != null) {
                    try {
                        value = (String)attr.get(0);
                    }
                    catch (NamingException e) {
                        this.log.info((Object)("Accessing attribute " + attrName + " threw Naming Exception."));
                    }
                } else {
                    this.log.info((Object)("Accessing attribute " + attrName + " resulted in null - check name in property file"));
                }
                result.put(attrName, value);
            }
        }
        return result;
    }
}

