/*
 * Decompiled with CFR 0.152.
 */
package de.starwit.auth.userdata;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigData
extends Properties {
    private static final long serialVersionUID = 1L;
    private static ConfigData instance;
    private List<String> attributeNames;
    private static final String configFileName = "userDirectoryConnection.properties";
    private Logger log = Logger.getLogger(ConfigData.class);

    public static ConfigData getInstance() {
        if (instance == null) {
            instance = new ConfigData();
        }
        return instance;
    }

    private ConfigData() {
        String configFilePath = this.computeConfigFilePath();
        FileInputStream input = null;
        try {
            input = new FileInputStream(configFilePath);
            this.load(input);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)("Could not find property file - Filter will not work! " + e.getMessage()));
        }
        catch (IOException e) {
            this.log.error((Object)"couldn't read from property file - Filter will not work!");
        }
        this.attributeNames = new ArrayList<String>();
        String attributeNamesString = (String)this.get("attributes");
        StringTokenizer st = new StringTokenizer(attributeNamesString, ",");
        while (st.hasMoreElements()) {
            String attrName = (String)st.nextElement();
            this.attributeNames.add(attrName);
        }
    }

    private String computeConfigFilePath() {
        String configFilePath = System.getProperty("starwit.userdata.configfile");
        if (configFilePath == null || "".equals(configFilePath)) {
            this.log.warn((Object)"no path to config file provided, try to load default filename userDirectoryConnection.properties from execution path - this should be configured explicitly!");
            configFilePath = configFileName;
        }
        return configFilePath;
    }

    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    public void setAttributeNames(List<String> attributeNames) {
        this.attributeNames = attributeNames;
    }
}

