/*
 * Decompiled with CFR 0.152.
 */
package de.staatsbibliothek.berlin.hsp.messaging.activitystreams.impl.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.staatsbibliothek.berlin.hsp.messaging.activitystreams.api.exceptions.ActivityStreamsException;
import de.staatsbibliothek.berlin.hsp.messaging.activitystreams.api.model.ActivityStreamObject;
import de.staatsbibliothek.berlin.hsp.messaging.activitystreams.api.model.ActivityStreamObjectBuilder;
import de.staatsbibliothek.berlin.hsp.messaging.activitystreams.api.model.ActivityStreamObjectTag;
import de.staatsbibliothek.berlin.hsp.messaging.activitystreams.api.model.enums.ActivityStreamsDokumentTyp;
import de.staatsbibliothek.berlin.hsp.messaging.objectfactory.TEIObjectFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tei_c.ns._1.TEI;

public class HSPActivityStreamObject<T>
implements ActivityStreamObject {
    private static final Logger log = LoggerFactory.getLogger(HSPActivityStreamObject.class);
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="groupId")
    private String groupId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="compressed")
    private boolean compressed;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="tag")
    private List<ActivityStreamObjectTag> tag;
    @JsonProperty(value="mediaType")
    private String mediaType;
    @JsonProperty(value="content")
    protected String content;

    HSPActivityStreamObject() {
        this.compressed = true;
        this.tag = new ArrayList<ActivityStreamObjectTag>();
    }

    private HSPActivityStreamObject(HSPActivityStreamObjectBuilder builder) throws ActivityStreamsException {
        this.id = builder.id;
        this.groupId = builder.groupId;
        this.name = builder.name;
        this.compressed = builder.compressed;
        Objects.requireNonNull(builder.type, "Type parameter is required and can't be null");
        this.setType(builder.type);
        this.url = builder.url;
        this.tag = builder.tag;
        this.mediaType = builder.mediaType;
        if (builder.tei != null) {
            this.setContent(builder.tei);
        }
        if (builder.string != null) {
            this.setContent(builder.string);
        }
        if (builder.bytes != null) {
            this.setContent(builder.bytes);
        }
    }

    @Override
    public ActivityStreamsDokumentTyp getType() {
        return ActivityStreamsDokumentTyp.valueFrom(this.type);
    }

    @Override
    public void setType(ActivityStreamsDokumentTyp type) {
        this.type = type != null ? type.toString() : null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean isCompressed() {
        return this.compressed;
    }

    @Override
    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public List<ActivityStreamObjectTag> getTag() {
        return this.tag;
    }

    @Override
    public void setTag(List<ActivityStreamObjectTag> tag) {
        this.tag = tag;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    @JsonIgnore
    public void setContent(String content) throws ActivityStreamsException {
        this.setContent(content.getBytes(StandardCharsets.UTF_8));
    }

    @JsonIgnore
    public void setContent(byte[] content) throws ActivityStreamsException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             GZIPOutputStream gzipOutputStream = new GZIPOutputStream(out);){
            if (this.compressed) {
                gzipOutputStream.write(content, 0, content.length);
                gzipOutputStream.finish();
                gzipOutputStream.flush();
                this.content = Base64.getEncoder().encodeToString(out.toByteArray());
            } else {
                this.content = Base64.getEncoder().encodeToString(content);
            }
        }
        catch (IOException e) {
            log.error("Unable to convert content", (Throwable)e);
            throw new ActivityStreamsException("Unable to convert content", e);
        }
    }

    @JsonIgnore
    public void setContent(TEI contentFromTEI) throws ActivityStreamsException {
        try {
            String marshal = TEIObjectFactory.marshal((TEI)contentFromTEI);
            this.setContent(marshal.getBytes(StandardCharsets.UTF_8));
            this.version = contentFromTEI.getVersion();
        }
        catch (JAXBException e) {
            log.error("Unable to convert TEI to Content", (Throwable)e);
            throw new ActivityStreamsException("Unable to convert TEI to Content", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @JsonIgnore
    public byte[] getContent() throws ActivityStreamsException {
        if (Objects.isNull(this.content)) {
            return null;
        }
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.getDecoder().decode(this.content));){
            if (this.compressed) {
                try (GZIPInputStream gzipInputStream = new GZIPInputStream(byteArrayInputStream);){
                    byte[] byArray = gzipInputStream.readAllBytes();
                    return byArray;
                }
            }
            byte[] byArray = ((InputStream)byteArrayInputStream).readAllBytes();
            return byArray;
        }
        catch (IOException e) {
            throw new ActivityStreamsException(e);
        }
    }

    public static ActivityStreamObjectBuilder builder() {
        return new HSPActivityStreamObjectBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HSPActivityStreamObject that = (HSPActivityStreamObject)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.groupId, that.groupId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.groupId);
    }

    public String toString() {
        StringBuilder tagContent = new StringBuilder();
        if (this.tag == null) {
            tagContent.append("null");
        } else {
            this.tag.forEach(hspActivityStreamObjectTag -> {
                tagContent.append(hspActivityStreamObjectTag.toString());
                tagContent.append("  ");
            });
        }
        return new StringJoiner(", ", HSPActivityStreamObject.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("groupId='" + this.groupId + "'").add("name='" + this.name + "'").add("version='" + this.version + "'").add("compressed=" + this.compressed).add("type=" + this.type).add("url='" + this.url + "'").add("content='" + this.content + "'").add("tag='" + tagContent.toString() + "'").toString();
    }

    public static class HSPActivityStreamObjectBuilder
    implements ActivityStreamObjectBuilder {
        private String id;
        private String groupId;
        private String name;
        private boolean compressed;
        private ActivityStreamsDokumentTyp type;
        private String url;
        public String mediaType;
        private List<ActivityStreamObjectTag> tag = new ArrayList<ActivityStreamObjectTag>();
        private TEI tei;
        private String string;
        private byte[] bytes;

        private HSPActivityStreamObjectBuilder() {
        }

        @Override
        public ActivityStreamObjectBuilder withId(String id) {
            this.id = id;
            return this;
        }

        @Override
        public ActivityStreamObjectBuilder withGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public ActivityStreamObjectBuilder withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public ActivityStreamObjectBuilder withCompressed(boolean compressed) {
            this.compressed = compressed;
            return this;
        }

        @Override
        public ActivityStreamObjectBuilder withType(ActivityStreamsDokumentTyp type) {
            this.type = type;
            return this;
        }

        @Override
        public ActivityStreamObjectBuilder withUrl(String url) {
            this.url = url;
            return this;
        }

        @Override
        public ActivityStreamObjectBuilder withMediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        @Override
        public ActivityStreamObjectBuilder withContent(String content) {
            this.string = content;
            return this;
        }

        @Override
        public ActivityStreamObjectBuilder withContent(TEI content) {
            this.tei = content;
            return this;
        }

        @Override
        public ActivityStreamObjectBuilder withContent(byte[] content) {
            this.bytes = content;
            return this;
        }

        @Override
        public ActivityStreamObjectBuilder withTag(List<ActivityStreamObjectTag> tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public HSPActivityStreamObject build() throws ActivityStreamsException {
            return new HSPActivityStreamObject(this);
        }
    }
}

