/*
 * Decompiled with CFR 0.152.
 */
package de.staatsbibliothek.berlin.hsp.messaging.activitystreams.impl.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.staatsbibliothek.berlin.hsp.messaging.activitystreams.api.exceptions.ActivityStreamsException;
import de.staatsbibliothek.berlin.hsp.messaging.activitystreams.api.model.ActivityStream;
import de.staatsbibliothek.berlin.hsp.messaging.activitystreams.api.model.ActivityStreamActor;
import de.staatsbibliothek.berlin.hsp.messaging.activitystreams.api.model.ActivityStreamBuilder;
import de.staatsbibliothek.berlin.hsp.messaging.activitystreams.api.model.ActivityStreamObject;
import de.staatsbibliothek.berlin.hsp.messaging.activitystreams.api.model.ActivityStreamTarget;
import de.staatsbibliothek.berlin.hsp.messaging.activitystreams.api.model.enums.ActivityStreamAction;
import de.staatsbibliothek.berlin.hsp.messaging.activitystreams.impl.model.HSPActivityStreamActor;
import de.staatsbibliothek.berlin.hsp.messaging.activitystreams.impl.model.HSPActivityStreamTarget;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class ActivityStreamMessage
implements ActivityStream {
    @JsonProperty(value="@context")
    private String context;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="action")
    private String action;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="published")
    private LocalDateTime published;
    @JsonProperty(value="summary")
    private String summary;
    @JsonProperty(value="objects")
    private List<ActivityStreamObject> objects = new ArrayList<ActivityStreamObject>();
    @JsonProperty(value="actor")
    private ActivityStreamActor actor = new HSPActivityStreamActor();
    @JsonProperty(value="target")
    private ActivityStreamTarget target = new HSPActivityStreamTarget();

    protected ActivityStreamMessage() {
    }

    public ActivityStreamMessage(ActivityStreamMessageBuilder builder) {
        this();
        this.id = builder.id;
        this.setAction(builder.action);
        this.published = builder.published;
        this.actor.setId(this.id);
        this.actor = new HSPActivityStreamActor();
        this.actor.setName(builder.actorName);
        this.target.setId(this.id);
        this.target.setName(builder.targetName);
        this.objects.addAll(builder.objects);
        this.version = this.determineVersion();
    }

    public static ActivityStreamBuilder builder() {
        return new ActivityStreamMessageBuilder();
    }

    private String determineVersion() {
        return ActivityStreamVersion.V1_0.toString();
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public void setContext(String context) {
        this.context = context;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public ActivityStreamAction getAction() {
        return ActivityStreamAction.valueFrom(this.action);
    }

    @Override
    public void setAction(ActivityStreamAction action) {
        this.action = action != null ? action.toString() : null;
    }

    @Override
    public LocalDateTime getPublished() {
        return this.published;
    }

    @Override
    public void setPublished(LocalDateTime published) {
        this.published = published;
    }

    @Override
    public ActivityStreamActor getActor() {
        return this.actor;
    }

    @Override
    public void setActor(ActivityStreamActor actor) {
        this.actor = actor;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public List<ActivityStreamObject> getObjects() {
        return this.objects;
    }

    @Override
    public void addObject(ActivityStreamObject object) {
        this.objects.add(object);
    }

    @Override
    public void removeObject(ActivityStreamObject object) {
        this.objects.remove(object);
    }

    @Override
    public ActivityStreamTarget getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(ActivityStreamTarget target) {
        this.target = target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityStreamMessage that = (ActivityStreamMessage)o;
        return Objects.equals(this.context, that.context) && Objects.equals(this.id, that.id) && this.action == that.action && Objects.equals(this.published, that.published) && Objects.equals(this.summary, that.summary) && Objects.equals(this.objects, that.objects) && Objects.equals(this.actor, that.actor) && Objects.equals(this.version, that.version) && Objects.equals(this.target, that.target);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.id, this.action, this.published, this.summary, this.objects, this.actor, this.target, this.version);
    }

    public String toString() {
        return new StringJoiner(", ", ActivityStreamMessage.class.getSimpleName() + "[", "]").add("context='" + this.context + "'").add("id='" + this.id + "'").add("action=" + this.action).add("published=" + this.published).add("summary='" + this.summary + "'").add("objects=" + this.objects).add("actor=" + this.actor).add("target=" + this.target).toString();
    }

    public static class ActivityStreamMessageBuilder
    implements ActivityStreamBuilder {
        private String id;
        private ActivityStreamAction action;
        private List<ActivityStreamObject> objects = new ArrayList<ActivityStreamObject>();
        private LocalDateTime published;
        private String actorName;
        private String targetName;

        private ActivityStreamMessageBuilder() {
        }

        @Override
        public ActivityStreamBuilder withId(String id) {
            this.id = id;
            return this;
        }

        @Override
        public ActivityStreamBuilder withType(ActivityStreamAction action) {
            this.action = action;
            return this;
        }

        @Override
        public ActivityStreamBuilder addObject(ActivityStreamObject object) {
            this.objects.add(object);
            return this;
        }

        @Override
        public ActivityStreamBuilder withPublished(LocalDateTime published) {
            this.published = published;
            return this;
        }

        @Override
        public ActivityStreamBuilder withActorName(String actorName) {
            this.actorName = actorName;
            return this;
        }

        @Override
        public ActivityStreamBuilder withTargetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        @Override
        public ActivityStream build() throws ActivityStreamsException {
            return new ActivityStreamMessage(this);
        }
    }

    protected static enum ActivityStreamVersion {
        V1_0;


        public String toString() {
            switch (this) {
                case V1_0: {
                    return "1.0";
                }
            }
            return "";
        }
    }
}

