/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.mobiledetector.model;

import de.sstoehr.mobiledetector.model.DevicePlatform;
import de.sstoehr.mobiledetector.model.DeviceType;

public class Device {
    public static final Device UNKNOWN = new Device();
    private final DeviceType type;
    private final DevicePlatform platform;

    public Device(DeviceType type, DevicePlatform platform) {
        this.type = type == null ? DeviceType.UNKNOWN : type;
        this.platform = platform == null ? DevicePlatform.UNKNOWN : platform;
    }

    public Device() {
        this(DeviceType.UNKNOWN, DevicePlatform.UNKNOWN);
    }

    public Device type(DeviceType deviceType) {
        return new Device(deviceType, this.platform);
    }

    public Device platform(DevicePlatform devicePlatform) {
        return new Device(this.type, devicePlatform);
    }

    public DeviceType type() {
        return this.type;
    }

    public DevicePlatform platform() {
        return this.platform;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device)o;
        if (this.type != device.type) {
            return false;
        }
        return this.platform == device.platform;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.platform.hashCode();
        return result;
    }

    public String toString() {
        return (Object)((Object)this.type) + " (" + (Object)((Object)this.platform) + ")";
    }
}

