package de.sstoehr.imageoptimizermavenplugin.optimizers;

import net.oneandone.sushi.fs.LengthException;
import net.oneandone.sushi.fs.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOptimizer implements Optimizer {

    private static final Logger LOG = LoggerFactory.getLogger(Optimizer.class);

    @Override
    public final OptimizerResult optimize(final Node img) {
        try {
            long preSize = img.length();
            process(img);
            long postSize = img.length();

            return new OptimizerResult(img.getPath(), preSize, postSize);
        } catch (LengthException e) {
            LOG.info("Error processing image.", e);
        }

        return null;
    }

    protected abstract void process(Node img);
}
