package de.sstoehr.imageoptimizermavenplugin.optimizers;

import net.oneandone.sushi.fs.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;

public abstract class AbstractCliOptimizer extends AbstractOptimizer {

    private static final Logger LOG = LoggerFactory.getLogger(AbstractCliOptimizer.class);

    private String executable;

    public AbstractCliOptimizer(final String executableName) {
        this.executable = findInPath(executableName);
        if (this.executable == null) {
            throw new UnsupportedOptimizerException("Executable not found in PATH.");
        }
    }

    private String findInPath(final String executableName) {
        String path = System.getenv("path");
        if (path == null) {
            path = System.getenv("PATH");
        }

        if (path == null) {
            return null;
        }

        for (String p : path.split(File.pathSeparator)) {
            File pFile = new File(p + File.separator + executableName);
            if (pFile.exists()) {
                return pFile.getAbsolutePath();
            }
        }

        return null;
    }

    @Override
    protected void process(final Node img) {
        LOG.debug("Processing image {}", img.getPath());
        ProcessBuilder pb = getProcessBuilder(executable, img);
        try {
            Process p = pb.start();
            p.waitFor();
        } catch (Exception e) {
            LOG.error("Error processing image.", e);
        }
    }

    protected abstract ProcessBuilder getProcessBuilder(final String exec, final Node img);

}
