package de.sstoehr.imageoptimizermavenplugin.jobs;

import de.sstoehr.imageoptimizermavenplugin.optimizers.OptimizerResult;

import java.util.ArrayList;
import java.util.List;

public class JobResult {

    private String name;
    private List<OptimizerResult> results = new ArrayList<>();

    public JobResult(final String name) {
        this.name = name;
    }

    public final void add(final OptimizerResult result) {
        if (result == null) {
            return;
        }
        this.results.add(result);
    }

    public String getName() {
        return name;
    }

    public List<OptimizerResult> getResults() {
        return results;
    }

    @Override
    public String toString() {
        return "JobResult{"
               + "name='" + name + '\''
               + ", results=" + results
               + '}';
    }
}
