/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.imageoptimizermavenplugin.optimizers;

import de.sstoehr.imageoptimizermavenplugin.optimizers.AbstractCliOptimizer;
import net.oneandone.sushi.fs.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpegOptim
extends AbstractCliOptimizer {
    private static final Logger LOG = LoggerFactory.getLogger(JpegOptim.class);

    public JpegOptim() {
        super("jpegoptim");
    }

    @Override
    protected final void process(Node img) {
        LOG.debug("Processing image {}", (Object)img.getPath());
        ProcessBuilder pb = new ProcessBuilder(this.executable, "-q", img.getURI().getPath());
        try {
            Process p = pb.start();
            p.waitFor();
        }
        catch (Exception e) {
            LOG.error("Error processing image.", (Throwable)e);
        }
    }
}

