/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.imageoptimizermavenplugin.optimizers;

import de.sstoehr.imageoptimizermavenplugin.optimizers.Optimizer;
import de.sstoehr.imageoptimizermavenplugin.optimizers.OptimizerResult;
import net.oneandone.sushi.fs.LengthException;
import net.oneandone.sushi.fs.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOptimizer
implements Optimizer {
    private static final Logger LOG = LoggerFactory.getLogger(Optimizer.class);

    @Override
    public final OptimizerResult optimize(Node img) {
        try {
            long preSize = img.length();
            this.process(img);
            long postSize = img.length();
            return new OptimizerResult(img.getPath(), preSize, postSize);
        }
        catch (LengthException e) {
            LOG.info("Error processing image.", (Throwable)e);
            return null;
        }
    }

    protected abstract void process(Node var1);
}

