/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.imageoptimizermavenplugin.optimizers;

import de.sstoehr.imageoptimizermavenplugin.optimizers.AbstractOptimizer;
import de.sstoehr.imageoptimizermavenplugin.optimizers.UnsupportedOptimizerException;
import java.io.File;

public abstract class AbstractCliOptimizer
extends AbstractOptimizer {
    protected String executable;

    public AbstractCliOptimizer(String executableName) {
        this.executable = this.findInPath(executableName);
        if (this.executable == null) {
            throw new UnsupportedOptimizerException("Executable not found in PATH.");
        }
    }

    private String findInPath(String executableName) {
        String path = System.getenv("path");
        if (path == null) {
            path = System.getenv("PATH");
        }
        if (path == null) {
            return null;
        }
        for (String p : path.split(File.pathSeparator)) {
            File pFile = new File(p + File.separator + executableName);
            if (!pFile.exists()) continue;
            return pFile.getAbsolutePath();
        }
        return null;
    }
}

