/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.imageoptimizermavenplugin.jobs;

import de.sstoehr.imageoptimizermavenplugin.jobs.Job;
import de.sstoehr.imageoptimizermavenplugin.jobs.JobResult;
import de.sstoehr.imageoptimizermavenplugin.optimizers.OptimizerResult;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.oneandone.sushi.fs.Node;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRunner {
    private static final Logger LOG = LoggerFactory.getLogger(JobRunner.class);
    private static final ThreadLocal<DecimalFormat> PERCENTAGE_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("0.00%");
        }
    };
    private List<Job> jobs = new ArrayList<Job>();
    private Node base;

    public JobRunner(Node base) {
        this.base = base;
    }

    public void schedule(Job job) {
        this.jobs.add(job);
    }

    public boolean run() {
        if (this.jobs.size() > 0) {
            LOG.info("Processing {} job(s).", (Object)this.jobs.size());
            ExecutorService executorService = Executors.newCachedThreadPool();
            try {
                List results = executorService.invokeAll(this.jobs);
                for (Future future : results) {
                    JobResult result = (JobResult)future.get();
                    LOG.info("=== {} ===", (Object)result.getName());
                    for (OptimizerResult optimizerResult : result.getResults()) {
                        long saved = optimizerResult.getPreSize() - optimizerResult.getPostSize();
                        double percentage = (double)saved / (double)optimizerResult.getPreSize();
                        if (saved == 0L) continue;
                        String path = optimizerResult.getPath();
                        path = path.replaceFirst(this.base.getPath(), "");
                        String savedReadable = FileUtils.byteCountToDisplaySize((long)saved);
                        String percentageReadable = PERCENTAGE_FORMAT.get().format(percentage);
                        LOG.info("{} - {} ({})", new Object[]{path, savedReadable, percentageReadable});
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.error("Error processing images", (Throwable)e);
            }
            catch (ExecutionException e) {
                LOG.error("Error processing images", (Throwable)e);
            }
            executorService.shutdown();
            return true;
        }
        LOG.info("No jobs configured.");
        return false;
    }
}

