/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.imageoptimizermavenplugin.jobs;

import de.sstoehr.imageoptimizermavenplugin.jobs.JobResult;
import de.sstoehr.imageoptimizermavenplugin.optimizers.Optimizer;
import de.sstoehr.imageoptimizermavenplugin.optimizers.OptimizerResult;
import java.util.concurrent.Callable;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.filter.Filter;

public class Job
implements Callable<JobResult> {
    private static final String DELIMITER = ",";
    private String name;
    private Node base;
    private Filter filter;
    private Optimizer optimizer;

    public Job(String name, Node base, Filter filter, Optimizer optimizer) {
        this.name = name;
        this.base = base;
        this.filter = filter;
        this.optimizer = optimizer;
    }

    public Job(String name, Node base, String filter, Optimizer optimizer) {
        this(name, base, new Filter(), optimizer);
        if (filter != null) {
            String[] includes;
            for (String include : includes = filter.split(DELIMITER)) {
                this.filter.include(new String[]{include});
            }
        }
    }

    @Override
    public final JobResult call() throws Exception {
        JobResult result = new JobResult(this.name);
        for (Node img : this.base.find(this.filter)) {
            OptimizerResult res = this.optimizer.optimize(img);
            if (res == null) continue;
            result.add(res);
        }
        return result;
    }
}

