/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.imageoptimizermavenplugin;

import de.sstoehr.imageoptimizermavenplugin.jobs.Job;
import de.sstoehr.imageoptimizermavenplugin.jobs.JobRunner;
import de.sstoehr.imageoptimizermavenplugin.optimizers.JpegOptim;
import de.sstoehr.imageoptimizermavenplugin.optimizers.Optimizer;
import de.sstoehr.imageoptimizermavenplugin.optimizers.PngQuant;
import de.sstoehr.imageoptimizermavenplugin.optimizers.UnsupportedOptimizerException;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.World;
import net.oneandone.sushi.fs.file.FileNode;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="optimize", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresProject=true)
public class ImageOptimizerMojo
extends AbstractMojo {
    private static final Logger LOG = LoggerFactory.getLogger(ImageOptimizerMojo.class);
    @Parameter
    private String jpegFilter = "**/*.jpg,**/*.jpeg,**/*.JPG,**/*.JPEG";
    @Parameter
    private String pngFilter = "**/*.png,**/*.PNG";
    @Component
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        World world = new World();
        FileNode base = world.file(this.project.getBasedir());
        JobRunner jobRunner = new JobRunner((Node)base);
        if (!this.jpegFilter.equalsIgnoreCase("false")) {
            JpegOptim jpegOptimizer = null;
            try {
                jpegOptimizer = new JpegOptim();
            }
            catch (UnsupportedOptimizerException e) {
                LOG.info("JpegOptim is not installed: https://github.com/sdstoehr/image-optimizer-maven-plugin/wiki/Install");
            }
            if (jpegOptimizer != null) {
                Job jpegJob = new Job("JPEG", (Node)base, this.jpegFilter, (Optimizer)jpegOptimizer);
                jobRunner.schedule(jpegJob);
            }
        }
        if (!this.pngFilter.equalsIgnoreCase("false")) {
            PngQuant pngOptimizer = null;
            try {
                pngOptimizer = new PngQuant();
            }
            catch (UnsupportedOptimizerException e) {
                LOG.info("PngQuant is not installed: https://github.com/sdstoehr/image-optimizer-maven-plugin/wiki/Install");
            }
            if (pngOptimizer != null) {
                Job pngJob = new Job("PNG", (Node)base, this.pngFilter, (Optimizer)pngOptimizer);
                jobRunner.schedule(pngJob);
            }
        }
        jobRunner.run();
    }
}

