package de.sstoehr.imageoptimizermavenplugin.optimizers;

import net.oneandone.sushi.fs.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PngQuant extends AbstractCliOptimizer {

    private static final Logger LOG = LoggerFactory.getLogger(PngQuant.class);

    public PngQuant() {
        super("pngquant");
    }

    @Override
    protected final void process(final Node img) {
        LOG.debug("Processing image {}", img.getPath());
        ProcessBuilder pb = new ProcessBuilder(executable, "--ext .png", img.getURI().getPath());
        try {
            Process p = pb.start();
            p.waitFor();
        } catch (Exception e) {
            LOG.error("Error processing image.", e);
        }
    }
}
