package de.sstoehr.imageoptimizermavenplugin.optimizers;

import java.io.File;

public abstract class AbstractCliOptimizer extends AbstractOptimizer {

    protected String executable;

    public AbstractCliOptimizer(final String executableName) {
        this.executable = findInPath(executableName);
        if (this.executable == null) {
            throw new UnsupportedOptimizerException("Executable not found in PATH.");
        }
    }

    private String findInPath(final String executableName) {
        String path = System.getenv("path");
        if (path == null) {
            path = System.getenv("PATH");
        }

        if (path == null) {
            return null;
        }

        for (String p : path.split(File.pathSeparator)) {
            File pFile = new File(p + File.separator + executableName);
            if (pFile.exists()) {
                return pFile.getAbsolutePath();
            }
        }

        return null;
    }

}
