package de.sstoehr.imageoptimizermavenplugin.jobs;

import de.sstoehr.imageoptimizermavenplugin.optimizers.OptimizerResult;
import lombok.Getter;
import lombok.ToString;

import java.util.ArrayList;
import java.util.List;

@Getter
@ToString
public class JobResult {

    private String name;
    private List<OptimizerResult> results = new ArrayList<>();

    public JobResult(final String name) {
        this.name = name;
    }

    public final void add(final OptimizerResult result) {
        if (result == null) {
            return;
        }
        this.results.add(result);
    }

}
