package de.sstoehr.imageoptimizermavenplugin.jobs;

import de.sstoehr.imageoptimizermavenplugin.optimizers.Optimizer;
import de.sstoehr.imageoptimizermavenplugin.optimizers.OptimizerResult;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.filter.Filter;

import java.util.concurrent.Callable;

public class Job implements Callable<JobResult> {

    private static final String DELIMITER = ",";

    private String name;
    private Node base;
    private Filter filter;
    private Optimizer optimizer;

    public Job(final String name, final Node base, final Filter filter, final Optimizer optimizer) {
        this.name = name;
        this.base = base;
        this.filter = filter;
        this.optimizer = optimizer;
    }

    public Job(final String name, final Node base, final String filter, final Optimizer optimizer) {
        this(name, base, new Filter(), optimizer);
        if (filter != null) {
            String[] includes = filter.split(DELIMITER);
            for (String include : includes) {
                this.filter.include(include);
            }
        }
    }

    @Override
    public final JobResult call() throws Exception {
        JobResult result = new JobResult(name);
        for (Node img : base.find(filter)) {
            OptimizerResult res = optimizer.optimize(img);
            if (res != null) {
                result.add(res);
            }
        }
        return result;
    }

}
