package de.sstoehr.harreader.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;

/**
 * Information about the response's content.
 * @see <a href="http://www.softwareishard.com/blog/har-12-spec/#content">specification</a>
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public record HarContent(
        @Nullable Long size,
        @Nullable Long compression,
        @Nullable String mimeType,
        @Nullable String text,
        @Nullable String encoding,
        @Nullable String comment,
        @Nonnull Map<String, Object> additional) {

    public HarContent() {
        this(null, null, null, null, null, null, new HashMap<>());
    }

    public HarContent(@Nullable Long size,
                      @Nullable Long compression,
                      @Nullable String mimeType,
                      @Nullable String text,
                      @Nullable String encoding,
                      @Nullable String comment,
                      @Nullable Map<String, Object> additional) {
        this.size = size;
        this.compression = compression;
        this.mimeType = mimeType;
        this.text = text;
        this.encoding = encoding;
        this.comment = comment;
        this.additional = (additional == null) ? new HashMap<>() : additional;
    }

    /**
     * @return Map with additional keys, which are not officially supported by the HAR specification
     */
    @JsonAnyGetter
    public Map<String, Object> additional() {
        return additional;
    }

    @JsonAnySetter
    public void setAdditionalField(String key, Object value) {
        this.additional.put(key, value);
    }

}
