/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.harreader;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.sstoehr.harreader.HarReaderException;
import de.sstoehr.harreader.HarReaderMode;
import de.sstoehr.harreader.jackson.MapperFactory;
import de.sstoehr.harreader.model.Har;
import java.io.File;
import java.io.IOException;

public class HarReader {
    private HarReader() {
    }

    public static Har fromFile(File har) throws HarReaderException {
        return HarReader.fromFile(har, HarReaderMode.STRICT);
    }

    public static Har fromFile(File har, HarReaderMode mode) throws HarReaderException {
        ObjectMapper mapper = MapperFactory.instance(mode);
        try {
            return (Har)mapper.readValue(har, Har.class);
        }
        catch (IOException e) {
            throw new HarReaderException(e);
        }
    }

    public static Har fromString(String har) throws HarReaderException {
        return HarReader.fromString(har, HarReaderMode.STRICT);
    }

    public static Har fromString(String har, HarReaderMode mode) throws HarReaderException {
        ObjectMapper mapper = MapperFactory.instance(mode);
        try {
            return (Har)mapper.readValue(har, Har.class);
        }
        catch (IOException e) {
            throw new HarReaderException(e);
        }
    }
}

