/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.harreader.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.sstoehr.harreader.model.HarCreatorBrowser;
import de.sstoehr.harreader.model.HarEntry;
import de.sstoehr.harreader.model.HarPage;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HarLog {
    protected static final String DEFAULT_VERSION = "1.1";
    private String version = "1.1";
    private HarCreatorBrowser creator;
    private HarCreatorBrowser browser;
    private List<HarPage> pages = new ArrayList<HarPage>();
    private List<HarEntry> entries = new ArrayList<HarEntry>();
    private String comment;

    @NotNull
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (version == null || version.trim().equals("")) {
            version = DEFAULT_VERSION;
        }
        this.version = version;
    }

    @Valid
    @NotNull
    public HarCreatorBrowser getCreator() {
        return this.creator;
    }

    public void setCreator(HarCreatorBrowser creator) {
        if (creator == null) {
            throw new IllegalArgumentException("Creator must not be null!");
        }
        this.creator = creator;
    }

    @Valid
    public HarCreatorBrowser getBrowser() {
        return this.browser;
    }

    public void setBrowser(HarCreatorBrowser browser) {
        this.browser = browser;
    }

    @Valid
    @NotNull
    public List<HarPage> getPages() {
        return this.pages;
    }

    public void setPages(List<HarPage> pages) {
        if (pages == null) {
            pages = new ArrayList<HarPage>();
        }
        this.pages = pages;
    }

    @Valid
    @NotNull
    public List<HarEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<HarEntry> entries) {
        if (entries == null) {
            entries = new ArrayList<HarEntry>();
        }
        this.entries = entries;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

