/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.harreader.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HarCache {
    private HarCacheInfo beforeRequest;
    private HarCacheInfo afterRequest;
    private String comment;

    @Valid
    public HarCacheInfo getBeforeRequest() {
        return this.beforeRequest;
    }

    public void setBeforeRequest(HarCacheInfo beforeRequest) {
        this.beforeRequest = beforeRequest;
    }

    @Valid
    public HarCacheInfo getAfterRequest() {
        return this.afterRequest;
    }

    public void setAfterRequest(HarCacheInfo afterRequest) {
        this.afterRequest = afterRequest;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class HarCacheInfo {
        private Date expires;
        private Date lastAccess;
        private String eTag;
        private Integer hitCount;
        private String comment;

        @JsonFormat(shape=JsonFormat.Shape.STRING)
        public Date getExpires() {
            return this.expires;
        }

        public void setExpires(Date expires) {
            this.expires = expires;
        }

        @NotNull
        @JsonFormat(shape=JsonFormat.Shape.STRING)
        public Date getLastAccess() {
            return this.lastAccess;
        }

        public void setLastAccess(Date lastAccess) {
            if (lastAccess == null) {
                throw new IllegalArgumentException("LastAccess must not be null!");
            }
            this.lastAccess = lastAccess;
        }

        @NotNull
        public String geteTag() {
            return this.eTag;
        }

        public void seteTag(String eTag) {
            if (eTag == null) {
                throw new IllegalArgumentException("ETag must not be null!");
            }
            this.eTag = eTag;
        }

        @NotNull
        public Integer getHitCount() {
            return this.hitCount;
        }

        public void setHitCount(Integer hitCount) {
            if (hitCount == null) {
                throw new IllegalArgumentException("HitCount must not be null!");
            }
            this.hitCount = hitCount;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }
}

