/*
 * Decompiled with CFR 0.152.
 */
package de.sstoehr.handlebars;

import de.sstoehr.handlebars.compiler.HandlebarsCompiler;
import java.io.IOException;
import java.util.LinkedHashMap;
import net.oneandone.sushi.fs.Node;
import net.oneandone.sushi.fs.World;
import net.oneandone.sushi.fs.file.FileNode;
import net.oneandone.sushi.fs.filter.Filter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="precompile", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresProject=true)
public class HandlebarsPrecompileMojo
extends AbstractMojo {
    private static final Logger LOG = LoggerFactory.getLogger(HandlebarsPrecompileMojo.class);
    private static final String DELIMITER = ",";
    @Parameter
    private String templatesFilter = "**/*.hbs";
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}/template.js")
    private String outputFile;
    @Parameter
    private String fileHeader = "var Handlebars = Handlebars || {};";
    @Parameter
    private String namespace = "Handlebars.templates";
    @Component
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        HandlebarsCompiler compiler = new HandlebarsCompiler();
        StringBuilder output = new StringBuilder();
        output.append(this.fileHeader);
        if (this.fileHeader.length() > 0) {
            output.append("\n");
        }
        World world = new World();
        FileNode base = world.file(this.project.getBasedir());
        Filter filter = this.getFilter(this.templatesFilter);
        LinkedHashMap<String, String> templates = new LinkedHashMap<String, String>();
        try {
            for (Node template : base.find(filter)) {
                String name = template.getName();
                String templateContent = template.readString();
                templates.put(name, templateContent);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading templates", (Exception)e);
        }
        String compiled = compiler.compileBatch(templates, this.namespace);
        output.append(compiled);
        FileNode outputNode = world.file(this.outputFile);
        try {
            outputNode.getParent().mkdirsOpt();
            outputNode.writeString(output.toString());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing output file.", (Exception)e);
        }
    }

    private Filter getFilter(String filter) {
        String[] includes;
        Filter f = new Filter();
        for (String include : includes = filter.split(DELIMITER)) {
            f.include(new String[]{include});
        }
        return f;
    }
}

