/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.umbrella;

import de.srsoftware.tools.Tools;
import de.srsoftware.tools.urls.Urls;
import de.srsoftware.umbrella.RedirectException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmbrellaConnector {
    private static final Logger Log = LoggerFactory.getLogger(UmbrellaConnector.class);
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private HashMap<String, String> tokens = new HashMap();
    private int port;

    public UmbrellaConnector(int port) {
        this.port = port;
        CookieManager cookieManager = new CookieManager();
        CookieHandler.setDefault(cookieManager);
    }

    private String encode(String value) {
        return URLEncoder.encode(value, UTF8);
    }

    private String getToken(URL url) throws RedirectException {
        String hostname = Urls.hostname((URL)url);
        String token = this.tokens.get(hostname);
        if (token == null) {
            try {
                this.request(url, null);
                token = this.readToken();
                if (token != null) {
                    this.tokens.put(hostname, token);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return token;
    }

    private void makePostRequest(HttpURLConnection connection, Map<String, String> data) throws IOException {
        StringJoiner arguments = new StringJoiner("&");
        for (Map.Entry<String, String> entry : data.entrySet()) {
            arguments.add(this.map(entry));
        }
        byte[] argBytes = arguments.toString().getBytes(UTF8);
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setFixedLengthStreamingMode(argBytes.length);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        connection.connect();
        try (OutputStream server = connection.getOutputStream();){
            server.write(argBytes);
        }
    }

    public static void main(String[] args) throws IOException, RedirectException {
        UmbrellaConnector umbrella = new UmbrellaConnector(8765);
        URL url = new URL("https://umbrella.srsoftware.de/mindmap/umbrella");
        String response = umbrella.request(url, new HashMap<String, String>(Map.of("id", "5")));
        Log.info("Response: {}", (Object)response);
    }

    private CharSequence map(Map.Entry<String, String> entry) {
        return this.encode(entry.getKey()) + "=" + this.encode(entry.getValue());
    }

    private String readToken() throws IOException {
        ServerSocket server = new ServerSocket(this.port);
        Socket client = server.accept();
        InputStream in = client.getInputStream();
        String response = "";
        byte[] buffer = new byte[1024];
        if (in.read(buffer) != -1) {
            response = new String(buffer, UTF8);
        }
        OutputStream out = client.getOutputStream();
        out.write("You may now close this page.".getBytes(UTF8));
        out.close();
        in.close();
        client.close();
        server.close();
        String[] lines = response.replace("\r", "").split("\n");
        Pattern pattern = Pattern.compile("token=(\\S+)");
        for (String line : lines) {
            Matcher m = pattern.matcher(line);
            if (!m.find()) continue;
            return m.group().substring(6);
        }
        return null;
    }

    public String request(URL url, Map<String, String> data) throws IOException, RedirectException {
        Log.debug("requesting {}", (Object)url);
        int count = 0;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(false);
        if (data != null) {
            this.makePostRequest(connection, data);
        }
        String redirect = connection.getHeaderField("Location");
        while (redirect != null) {
            if (++count > 7) {
                throw new RedirectException(redirect);
            }
            URL newUrl = new URL(redirect);
            if (redirect.contains("/login?")) {
                String loginPage = redirect.split("\\?")[0];
                Tools.openWebpage((String)(loginPage + "?returnTo=http://localhost:" + this.port + "/intelliMind"));
                String token = this.getToken(newUrl);
                Log.debug("Token: {}", (Object)token);
                newUrl = url;
                if (data == null) {
                    data = new HashMap<String, String>();
                }
                data.put("token", token);
            }
            Log.debug("requesting {}", (Object)newUrl);
            connection = (HttpURLConnection)newUrl.openConnection();
            connection.setInstanceFollowRedirects(false);
            if (data != null) {
                this.makePostRequest(connection, data);
            }
            redirect = connection.getHeaderField("Location");
        }
        InputStream in = connection.getInputStream();
        String response = new String(in.readAllBytes(), UTF8);
        in.close();
        return response;
    }
}

