/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools.files;

import de.keawe.tools.translations.Translation;
import java.io.File;

public class FileName {
    private String absoluteFilename;
    private static char sc = File.separatorChar;

    public static String searchFile(String filename) {
        FileName f = new FileName(filename);
        String result = FileName.searchFile(f.getFileNameFromPath().toUpperCase(), f.getPathNameFromPath());
        return result;
    }

    public static String searchFileUpward(String filename, int levels) {
        System.out.print(Translation.get(FileName.class, (String)"searching for file {}", (Object[])new Object[]{filename}));
        FileName f = new FileName(filename);
        String dir = f.getPathNameFromPath();
        int i = dir.lastIndexOf(sc);
        while (levels > 0) {
            --i;
            while (i > 0 && dir.charAt(i) != sc) {
                --i;
            }
            --levels;
        }
        if (i <= 0) {
            i = dir.indexOf(sc);
        }
        String result = FileName.searchFile(f.getFileNameFromPath().toUpperCase(), dir.substring(0, i + 1));
        System.out.println();
        return result;
    }

    private static String getPathMatch(String path1, String path2) {
        int i1 = path1.indexOf(sc);
        int i2 = path2.indexOf(sc);
        String matchPath = "";
        while (i1 > -1 && i2 > -1 && path2.substring(0, i2).equals(path1.substring(0, i1))) {
            matchPath = path1.substring(0, i1 + 1);
            i1 = path1.indexOf(sc, i1 + 1);
            i2 = path2.indexOf(sc, i2 + 1);
        }
        return matchPath;
    }

    private static String searchFile(String filename, String directory) {
        System.out.print('.');
        String[] list = new File(directory).list();
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            if (new File(directory + list[i]).isDirectory()) {
                String subDirResult = FileName.searchFile(filename, directory + list[i] + sc);
                if (subDirResult == null) continue;
                return subDirResult;
            }
            if (!list[i].toUpperCase().equals(filename)) continue;
            return directory + list[i];
        }
        return null;
    }

    private static String CollapseFilename(String f) {
        int i = f.indexOf(".." + sc);
        while (i > -1) {
            int j = f.substring(0, i - 1).lastIndexOf(sc);
            if (i > -1) {
                f = f.substring(0, j + 1) + f.substring(i + 3);
            }
            i = f.indexOf(".." + sc);
        }
        return f;
    }

    private static String fixPathSeparators(String path) {
        path = sc == '\\' ? path.replace('/', sc) : path.replace('\\', sc);
        return path;
    }

    public FileName() {
        this.absoluteFilename = null;
        sc = File.separatorChar;
    }

    public FileName(String filename) {
        int i = filename.indexOf(58);
        if (i > -1) {
            filename = filename.startsWith("http://") ? filename.substring(0, 5) + filename.substring(5).replace(':', '#') : (filename.startsWith("ftp://") ? filename.substring(0, 4) + filename.substring(4).replace(':', '#') : filename.substring(0, 2) + filename.substring(2).replace(':', '#'));
        }
        filename = filename.replace('?', '#');
        filename = filename.replace('*', '#');
        filename = filename.replace('\"', '#');
        filename = filename.replace('>', '#');
        filename = filename.replace('<', '#');
        filename = filename.replace('|', '#');
        this.absoluteFilename = FileName.CollapseFilename(FileName.fixPathSeparators(filename));
        sc = File.separatorChar;
    }

    public String getFileNameFromPath() {
        int i = this.absoluteFilename.lastIndexOf(sc);
        if (i > -1) {
            return this.absoluteFilename.substring(i + 1);
        }
        return this.absoluteFilename;
    }

    public String getPathNameFromPath() {
        int i = this.absoluteFilename.lastIndexOf(sc);
        if (i > -1) {
            return this.absoluteFilename.substring(0, i + 1);
        }
        return "";
    }

    public String getPathRelativeToFile(String baseFile) {
        FileName baseFileName = new FileName(baseFile);
        String targetFile = this.getFileNameFromPath();
        String targetPath = this.getPathNameFromPath();
        String basePath = baseFileName.getPathNameFromPath();
        String matchPath = FileName.getPathMatch(basePath, targetPath);
        int matchLength = matchPath.length();
        basePath = basePath.substring(matchLength);
        targetPath = targetPath.substring(matchLength);
        String relDir = "";
        if (matchLength > 0) {
            int index = basePath.indexOf(sc);
            while (index > -1) {
                relDir = relDir + ".." + sc;
                basePath = basePath.substring(index + 1);
                index = basePath.indexOf(sc);
            }
        }
        return relDir + targetPath + targetFile;
    }

    public void setFileName(String newFileName) {
        this.absoluteFilename = FileName.CollapseFilename(FileName.fixPathSeparators(newFileName));
    }

    public String toString() {
        return this.absoluteFilename;
    }

    public static String deleteNonFilenameChars(String string) {
        return string.replaceAll(":", "").replaceAll("/", "-").replaceAll("\\?", " ").replaceAll(" \\.", ".").replaceAll("\\. ", ".");
    }
}

