/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools.files;

import de.keawe.tools.translations.Translation;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.swing.JOptionPane;

public class FileTools {
    private static long searchTime = 0L;

    private static boolean checkSearchTime() {
        if (searchTime == -1L) {
            return false;
        }
        if (searchTime == 0L) {
            searchTime = new Date().getTime();
        } else if (new Date().getTime() - searchTime > 20000L) {
            if (JOptionPane.showConfirmDialog(null, Translation.get(FileTools.class, (String)"Seems like your search will last longer. Cancel search?", (Object[])new Object[0]), Translation.get(FileTools.class, (String)"Notification", (Object[])new Object[0]), 0) == 0) {
                searchTime = -1L;
                return false;
            }
            searchTime = new Date().getTime();
        }
        return true;
    }

    public static void createDirectory(String fname) {
        File f = new File(fname);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public static String deleteNonFilenameChars(String string) {
        return string.replaceAll(":", "").replaceAll("/", "-").replaceAll("\\?", " ").replaceAll(" \\.", ".").replaceAll("\\. ", ".");
    }

    public static boolean fileExists(URL fileUrl) {
        String s = fileUrl.toString();
        if (FileTools.isLocal(fileUrl)) {
            int i = s.indexOf(":");
            s = s.substring(i + 1);
            File f = new File(s);
            return f.exists();
        }
        try {
            System.out.print("Waiting for connection to " + fileUrl + "...");
            HttpURLConnection connection = (HttpURLConnection)fileUrl.openConnection();
            int code = connection.getResponseCode();
            if (code == 200) {
                System.out.println("established.");
                return true;
            }
            System.out.println("failed.");
            return false;
        }
        catch (IOException e) {
            System.out.println("failed.");
            return false;
        }
    }

    private static URL findIntern(String path, String ... names) {
        if (FileTools.checkSearchTime()) {
            File[] files;
            File f = new File(path);
            if (f.exists() && (files = f.listFiles()) != null) {
                for (File file : files) {
                    if (file != null && file.isDirectory()) {
                        URL result = FileTools.findIntern(file.getPath(), names);
                        if (result == null) continue;
                        return result;
                    }
                    for (String filename : names) {
                        if (!file.getName().toLowerCase().equals(filename.toLowerCase())) continue;
                        try {
                            searchTime = 0L;
                            return file.toURL();
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            return null;
        }
        return null;
    }

    public static String getFileString(URL url, boolean breakLines) throws IOException {
        StringBuffer result = new StringBuffer();
        InputStream inputStream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while (reader.ready()) {
            if (breakLines) {
                result.append(reader.readLine().trim() + '\n');
            } else {
                result.append(reader.readLine().trim());
            }
            if (reader.ready()) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        reader.close();
        return result.toString();
    }

    public static boolean isFreeMindFile(URL fileUrl) {
        return fileUrl.toString().toUpperCase().endsWith(".MM");
    }

    public static boolean isIntelliMindFile(URL fileUrl) {
        return fileUrl.toString().toUpperCase().endsWith(".IMF") || fileUrl.toString().toUpperCase().endsWith(".IMF.OLD");
    }

    public static boolean isKeggUrl(URL fileUrl) {
        String dummy = fileUrl.toString();
        if (dummy.startsWith("http://rest.kegg.jp/get/")) {
            return true;
        }
        return dummy.startsWith("http://www.genome.jp/dbget-bin");
    }

    public static boolean isLocal(URL fileUrl) {
        return fileUrl.toString().startsWith("file:");
    }

    public static URL searchFiles(String path, String ... names) {
        searchTime = 0L;
        return FileTools.findIntern(path, names);
    }
}

