/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools.gui;

import de.srsoftware.tools.translations.Translation;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DateChooser
extends JPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 8240006199572579622L;
    private Vector<JButton> dateButtons = new Vector();
    private TreeSet<ActionListener> actionListeners = new TreeSet();
    private JButton selectedButton = null;
    private JPanel buttonPanel;
    private JPanel yearPanel;
    private JLabel yearLabel;
    private JLabel monthLabel;
    private int year;
    private int month;
    private int firstDay;
    private String toolTipText;
    private JButton lastMonth;
    private JButton nextMonth;
    private JButton lastYear;
    private JButton nextYear;
    private String helpText = null;

    private static String t(String text) {
        return Translation.get(DateChooser.class, (String)text, (Object[])new Object[0]);
    }

    public DateChooser() {
        Date date = new Date();
        this.year = date.getYear() + 1900;
        this.month = date.getMonth() + 1;
        this.setLayout(new BoxLayout(this, 1));
        this.yearPanel = new JPanel();
        this.lastMonth = new JButton("<");
        this.lastMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooser.this.decreaseMonth();
            }
        });
        this.yearPanel.add(this.lastMonth);
        this.monthLabel = new JLabel(this.getMonth(this.month));
        this.yearPanel.add(this.monthLabel);
        this.nextMonth = new JButton(">");
        this.nextMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooser.this.increaseMonth();
            }
        });
        this.yearPanel.add(this.nextMonth);
        this.lastYear = new JButton("<");
        this.lastYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooser.this.year--;
                DateChooser.this.resetMonth();
            }
        });
        this.yearPanel.add(this.lastYear);
        this.yearLabel = new JLabel(String.valueOf(this.year));
        this.yearPanel.add(this.yearLabel);
        this.nextYear = new JButton(">");
        this.nextYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooser.this.year++;
                DateChooser.this.resetMonth();
            }
        });
        this.yearPanel.add(this.nextYear);
        this.add(this.yearPanel);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(7, 7));
        this.addDays();
        this.add(this.buttonPanel);
        this.setMonth();
        this.selectButton(this.dateButtons.get(date.getDate() + this.firstDay - 2));
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        JButton sender = (JButton)arg0.getSource();
        this.selectButton(sender);
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    public Date getSelectedDate() {
        if (this.selectedButton == null) {
            return null;
        }
        return new Date(this.year - 1900, this.month - 1, Integer.parseInt(this.selectedButton.getText()));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3 && this.helpText != null) {
            JOptionPane.showMessageDialog(this, this.helpText);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void setDate(int day, int month, int year) {
        this.month = month;
        this.year = year;
        this.resetMonth();
        this.selectButton(this.dateButtons.get(day + this.firstDay - 2));
    }

    public void setHelpText(String message) {
        this.helpText = message;
        this.addMouseListener(this);
    }

    @Override
    public void setToolTipText(String text) {
        this.buttonPanel.setToolTipText(text);
        this.yearPanel.setToolTipText(text);
        this.yearLabel.setToolTipText(text);
        this.monthLabel.setToolTipText(text);
        for (int i = 0; i < this.dateButtons.size(); ++i) {
            this.dateButtons.get(i).setToolTipText(text);
        }
        this.toolTipText = text;
        this.lastMonth.setToolTipText(text);
        this.nextMonth.setToolTipText(text);
        this.lastYear.setToolTipText(text);
        this.nextYear.setToolTipText(text);
    }

    private void addDateButton(JButton dateButton, int relativeMonth) {
        if (relativeMonth == 0) {
            dateButton.addActionListener(this);
        } else {
            dateButton.setForeground(Color.GRAY);
            if (relativeMonth < 0) {
                dateButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int day = Integer.parseInt(((JButton)e.getSource()).getText());
                        DateChooser.this.decreaseMonth();
                        DateChooser.this.selectButton((JButton)DateChooser.this.dateButtons.get(day + DateChooser.this.firstDay - 2));
                    }
                });
            } else {
                dateButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int day = Integer.parseInt(((JButton)e.getSource()).getText());
                        DateChooser.this.increaseMonth();
                        DateChooser.this.selectButton((JButton)DateChooser.this.dateButtons.get(day + DateChooser.this.firstDay - 2));
                    }
                });
            }
        }
        if (this.toolTipText != null) {
            dateButton.setToolTipText(this.toolTipText);
        }
        this.buttonPanel.add(dateButton);
        this.dateButtons.add(dateButton);
    }

    private void addDay(String d) {
        JLabel l = new JLabel(d);
        this.buttonPanel.add(l);
    }

    private void addDays() {
        this.addDay(DateChooser.t(" Mo"));
        this.addDay(DateChooser.t(" Tu"));
        this.addDay(DateChooser.t(" We"));
        this.addDay(DateChooser.t(" Th"));
        this.addDay(DateChooser.t(" Fr"));
        this.addDay(DateChooser.t(" Sa"));
        this.addDay(DateChooser.t(" Su"));
    }

    private String getMonth(int month) {
        switch (month) {
            case 1: {
                return DateChooser.t("January");
            }
            case 2: {
                return DateChooser.t("February");
            }
            case 3: {
                return DateChooser.t("March");
            }
            case 4: {
                return DateChooser.t("April");
            }
            case 5: {
                return DateChooser.t("May");
            }
            case 6: {
                return DateChooser.t("June");
            }
            case 7: {
                return DateChooser.t("July");
            }
            case 8: {
                return DateChooser.t("August");
            }
            case 9: {
                return DateChooser.t("September");
            }
            case 10: {
                return DateChooser.t("October");
            }
            case 11: {
                return DateChooser.t("November");
            }
        }
        return DateChooser.t("Dezember");
    }

    private void resetMonth() {
        this.yearLabel.setText(String.valueOf(this.year));
        this.monthLabel.setText(this.getMonth(this.month));
        for (int i = this.dateButtons.size() - 1; i >= 0; --i) {
            this.buttonPanel.remove(this.dateButtons.get(i));
        }
        this.dateButtons.clear();
        this.setMonth();
    }

    private void selectButton(JButton newSelected) {
        newSelected.setEnabled(false);
        if (this.selectedButton != null) {
            this.selectedButton.setBackground(newSelected.getBackground());
            this.selectedButton.setEnabled(true);
        }
        newSelected.setBackground(Color.BLUE);
        this.selectedButton = newSelected;
        ActionEvent ae = new ActionEvent(this, 0, null);
        Iterator<ActionListener> it = this.actionListeners.iterator();
        while (it.hasNext()) {
            it.next().actionPerformed(ae);
        }
    }

    private void setMonth() {
        Date date = new Date(this.year - 1900, this.month - 1, 1);
        int diff = 86400000;
        int prefix = -1;
        int counter = 0;
        while (date.getDay() != 1) {
            date = new Date(date.getTime() - (long)diff);
        }
        for (int i = 0; i < 42; ++i) {
            ++counter;
            int day = date.getDate();
            if (day == 1 && ++prefix == 0) {
                this.firstDay = counter;
            }
            this.addDateButton(new JButton(String.valueOf(day)), prefix);
            date.setDate(day + 1);
        }
    }

    protected void decreaseMonth() {
        --this.month;
        if (this.month < 1) {
            this.month = 12;
            --this.year;
        }
        this.resetMonth();
    }

    protected void increaseMonth() {
        ++this.month;
        if (this.month > 12) {
            this.month = 1;
            ++this.year;
        }
        this.resetMonth();
    }
}

