/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools;

import de.srsoftware.tools.Optionals;
import de.srsoftware.tools.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;

public class Tag
extends TreeMap<String, String> {
    private final List<Tag> children = new ArrayList<Tag>();
    private Tag parent;
    private final String type;

    public Tag(String type) {
        this.type = type;
    }

    public Tag add(Tag ... newChildren) {
        for (Tag child : newChildren) {
            if (child == null) continue;
            if (child.parent != null) {
                child.parent.removeChild(child);
            }
            child.parent = this;
            this.children.add(child);
        }
        return this;
    }

    public <T extends Tag> T addTo(T parent) {
        parent.children().add(this);
        this.parent = this;
        return parent;
    }

    public <T extends Tag> T alt(String txt) {
        return this.attr("alt", txt);
    }

    public <T extends Tag> T attr(String key, String val) {
        this.put(key, val);
        return (T)this;
    }

    public <T extends Tag> T attr(String key, int i) {
        return this.attr(key, "" + i);
    }

    public List<Tag> children() {
        return this.children;
    }

    public <T extends Tag> T clazz(Collection<String> classes) {
        this.attr("class", String.join((CharSequence)" ", classes));
        return (T)this;
    }

    public <T extends Tag> T clazz(String ... classes) {
        this.attr("class", String.join((CharSequence)" ", classes));
        return (T)this;
    }

    public <T extends Tag> T content(String content) {
        this.add(new Text(content));
        return (T)this;
    }

    public List<Tag> find(Predicate<Tag> filter) {
        ArrayList<Tag> hits = new ArrayList<Tag>();
        if (filter.test(this)) {
            hits.add(this);
        }
        for (Tag child : this.children) {
            hits.addAll(child.find(filter));
        }
        return hits;
    }

    public String flat() {
        StringBuilder sb = new StringBuilder("<" + this.type);
        Iterator iterator = this.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            sb.append(" ").append((String)entry.getKey());
            String value = (String)entry.getValue();
            if (value != null) {
                sb.append("=\"").append((String)entry.getValue()).append("\"");
            }
        }
        if (this.children.isEmpty()) {
            sb.append(" />");
        } else {
            sb.append(">\u2026</").append(this.type).append(">");
        }
        return sb.toString();
    }

    public <T extends Tag> T id(String id) {
        return this.attr("id", id);
    }

    protected void indent(StringBuilder sb, int indent, int currentIndentation) {
        boolean empty;
        boolean bl = empty = this.type == null || this.type.isBlank();
        if (!empty) {
            sb.append(" ".repeat(currentIndentation)).append("<").append(this.type);
            for (Map.Entry entry : this.entrySet()) {
                sb.append(" ").append((String)entry.getKey());
                String value = (String)entry.getValue();
                if (value == null) continue;
                sb.append("=\"").append((String)entry.getValue()).append("\"");
            }
        }
        if (this.children.isEmpty()) {
            sb.append(" />\n");
        } else {
            if (!empty) {
                sb.append(">").append("\n");
            }
            for (Tag tag : this.children) {
                tag.indent(sb, indent, currentIndentation + indent);
            }
            if (!empty) {
                sb.append(" ".repeat(currentIndentation));
            }
            if (!empty) {
                sb.append("</").append(this.type).append(">\n");
            }
        }
    }

    public Optional<String> inner(int indent) {
        if (this.children().isEmpty()) {
            return Optional.empty();
        }
        StringBuilder sb = new StringBuilder();
        this.children().forEach((? super T child) -> sb.append(child.toString(indent)));
        return Optional.of(sb.toString());
    }

    public boolean is(String type) {
        return this.type != null && this.type.equalsIgnoreCase(type);
    }

    public static Tag of(String type) {
        return new Tag(type);
    }

    public Optional<Tag> parent() {
        return Optionals.nullable((Object)this.parent);
    }

    public <T extends Tag> T pos(int x, int y) {
        return ((Tag)this.attr("x", x)).attr("y", y);
    }

    public <T extends Tag> T removeChild(Tag child) {
        this.children.remove(child);
        child.parent = null;
        return (T)this;
    }

    public Optional<Tag> remove() {
        return Optionals.nullable((Object)this.parent).map(p -> p.removeChild(this));
    }

    public <T extends Tag> T size(int width, int height) {
        return ((Tag)this.attr("width", width)).attr("height", height);
    }

    public <T extends Tag> T style(String style) {
        return this.attr("style", style);
    }

    public <T extends Tag> T title(String title) {
        return this.attr("title", title);
    }

    public String strip() {
        StringBuilder sb = new StringBuilder();
        this.children.stream().map(Tag::strip).forEach(sb::append);
        return sb.toString();
    }

    @Override
    public String toString() {
        boolean empty;
        StringBuilder sb = new StringBuilder();
        boolean bl = empty = this.type == null || this.type.isBlank();
        if (!empty) {
            sb.append("<").append(this.type);
            for (Map.Entry entry : this.entrySet()) {
                sb.append(" ").append((String)entry.getKey());
                String value = (String)entry.getValue();
                if (value == null) continue;
                sb.append("=\"").append((String)entry.getValue()).append("\"");
            }
        }
        if (this.children.isEmpty()) {
            sb.append(" />");
        } else {
            if (!empty) {
                sb.append(">");
            }
            for (Tag tag : this.children) {
                sb.append(tag.toString());
            }
            if (!empty) {
                sb.append("</").append(this.type).append(">");
            }
        }
        return sb.toString();
    }

    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        this.indent(sb, indent, 0);
        return sb.toString();
    }

    public String type() {
        return this.type;
    }
}

