/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools;

import de.srsoftware.tools.Tag;
import java.util.function.Predicate;

public class TagFilter {
    private TagFilter() {
    }

    public static Predicate<Tag> withAttribute(String attributeName) {
        return tag -> tag.get(attributeName) != null;
    }

    public static Predicate<Tag> ofType(String type) {
        if (type == null) {
            return t -> false;
        }
        return tag -> type.equals(tag.type());
    }

    public static Predicate<Tag> attributeEquals(String key, String value) {
        if (key == null) {
            return t -> false;
        }
        if (value == null) {
            return t -> false;
        }
        return tag -> value.equals(tag.get(key));
    }

    public static Predicate<Tag> attributeContains(String key, String value) {
        if (key == null) {
            return t -> false;
        }
        if (value == null) {
            return t -> false;
        }
        return tag -> {
            String val = (String)tag.get(key);
            return val != null && val.contains(value);
        };
    }

    public static Predicate<Tag> attributeHas(String key, String value) {
        if (key == null) {
            return t -> false;
        }
        if (value == null) {
            return t -> false;
        }
        return tag -> {
            String[] tokens;
            String val = (String)tag.get(key);
            if (val == null) {
                return false;
            }
            for (String token : tokens = val.split(" ")) {
                if (!token.equals(value)) continue;
                return true;
            }
            return false;
        };
    }

    public static Predicate<Tag> attributeStartsWith(String key, String value) {
        if (key == null) {
            return t -> false;
        }
        if (value == null) {
            return t -> false;
        }
        return tag -> {
            String val = (String)tag.get(key);
            return val != null && val.startsWith(value);
        };
    }

    public static Predicate<Tag> attributeEndsWith(String key, String value) {
        if (key == null) {
            return t -> false;
        }
        if (value == null) {
            return t -> false;
        }
        return tag -> {
            String val = (String)tag.get(key);
            return val != null && val.endsWith(value);
        };
    }
}

