/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools;

import de.srsoftware.tools.ClosedTag;
import de.srsoftware.tools.ClosingTag;
import de.srsoftware.tools.Comment;
import de.srsoftware.tools.Error;
import de.srsoftware.tools.OpeningTag;
import de.srsoftware.tools.ParseException;
import de.srsoftware.tools.Payload;
import de.srsoftware.tools.Result;
import de.srsoftware.tools.Tag;
import de.srsoftware.tools.Text;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class XMLParser {
    public static Result<Tag> parse(InputStream input) throws IOException, ParseException {
        List<Tag> result = XMLParser.parse(new PushbackReader(new InputStreamReader(input)));
        return result == null || result.isEmpty() ? Error.of((String)"nope!") : Payload.of((Object)result.removeFirst());
    }

    private static List<Tag> parse(PushbackReader input) throws IOException {
        ArrayList<Tag> tags;
        block6: {
            Tag result;
            tags = new ArrayList<Tag>();
            while (true) {
                int c;
                String prefix;
                if (!(prefix = XMLParser.readUntil(input, "<", true)).isBlank()) {
                    tags.add(new Text(prefix));
                }
                if ((c = XMLParser.read(input)) <= 0) break block6;
                if (c != 60) continue;
                String token = XMLParser.readUntil(input, ">", false);
                result = XMLParser.convert(token);
                if (result instanceof OpeningTag) {
                    Tag tag;
                    List<Tag> children = XMLParser.parse(input);
                    if (!children.isEmpty() && (tag = children.getLast()) instanceof ClosingTag) {
                        ClosingTag closingTag = (ClosingTag)tag;
                        if (!result.is(closingTag.type())) {
                            children.removeLast();
                            children.forEach(xva$0 -> result.add((Tag)xva$0));
                            tags.add(result);
                            break block6;
                        }
                        children.removeLast();
                    }
                    children.forEach(xva$0 -> result.add((Tag)xva$0));
                    tags.add(result);
                }
                if (result instanceof ClosedTag) {
                    tags.add(result);
                }
                if (result instanceof ClosingTag) break;
            }
            tags.add(result);
        }
        return tags;
    }

    private static Tag convert(String token) throws IOException {
        if (token.startsWith("/")) {
            return ClosingTag.of(token.substring(1));
        }
        if (token.startsWith("!")) {
            return Comment.of(token);
        }
        return XMLParser.toTag(token);
    }

    private static Tag toTag(String token) throws IOException {
        Tag tag;
        boolean closing = (token = token.trim()).endsWith("/");
        if (closing) {
            token = token.substring(0, token.length() - 2).trim();
        }
        if (token.isBlank()) {
            return null;
        }
        String[] parts = token.split(" ", 2);
        String type = parts[0];
        Tag tag2 = tag = closing ? ClosedTag.of(type) : OpeningTag.of(type);
        if (parts.length > 1) {
            XMLParser.fetchAttributes(tag, parts[1]);
        }
        return tag;
    }

    private static void fetchAttributes(Tag tag, String data) throws IOException {
        PushbackReader input = new PushbackReader(new StringReader(data));
        while (input.ready()) {
            String val;
            XMLParser.skipWhitespace(input);
            String token = XMLParser.readUntil(input, " ", true).trim();
            if (token.isEmpty()) {
                return;
            }
            String[] parts = token.split("=", 2);
            String key = parts[0];
            String string = val = parts.length > 1 ? parts[1] : null;
            if (val != null && val.startsWith("\"") && val.endsWith("\"")) {
                val = val.substring(1, val.length() - 1);
            }
            tag.attr(key, val);
        }
    }

    public static InputStream preload(InputStream input) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        input.transferTo(bos);
        input.close();
        return new ByteArrayInputStream(bos.toByteArray());
    }

    private static int read(PushbackReader input) throws IOException {
        if (!input.ready()) {
            return 0;
        }
        return input.read();
    }

    private static String readUntil(PushbackReader input, String delimiters, boolean pushBack) throws IOException {
        StringBuilder token = new StringBuilder();
        int c = XMLParser.read(input);
        while (XMLParser.unlimited(c, delimiters)) {
            switch (c) {
                case 34: {
                    token.append('\"').append(XMLParser.readUntil(input, "\"", false)).append('\"');
                    break;
                }
                case 39: {
                    token.append("'").append(XMLParser.readUntil(input, "'", false)).append("'");
                    break;
                }
                default: {
                    token.append((char)c);
                }
            }
            c = XMLParser.read(input);
        }
        if (pushBack && c > 0) {
            input.unread(c);
        }
        return token.toString();
    }

    private static void skipWhitespace(PushbackReader input) throws IOException {
        int c = XMLParser.read(input);
        while (c > 0 && Character.isWhitespace(c)) {
            c = XMLParser.read(input);
        }
        if (c > 0) {
            input.unread(c);
        }
    }

    private static boolean unlimited(int c, String delimiter) {
        return c > 0 && delimiter.indexOf(c) < 0;
    }
}

