/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Tag
extends HashMap<String, String> {
    private final List<Tag> children = new ArrayList<Tag>();
    private final String type;
    private String content = null;

    public Tag(String type) {
        this.type = type;
    }

    public Tag add(Tag ... tags) {
        for (Tag tag : tags) {
            if (tag == null) continue;
            this.children().add(tag);
        }
        return this;
    }

    public <T extends Tag> T addTo(T tag) {
        tag.children().add(this);
        return tag;
    }

    public <T extends Tag> T alt(String txt) {
        return this.attr("alt", txt);
    }

    public <T extends Tag> T attr(String key, String val) {
        this.put(key, val);
        return (T)this;
    }

    public <T extends Tag> T attr(String key, int i) {
        return this.attr(key, "" + i);
    }

    public List<Tag> children() {
        return this.children;
    }

    public <T extends Tag> T clazz(Collection<String> classes) {
        this.put("class", String.join((CharSequence)" ", classes));
        return (T)this;
    }

    public <T extends Tag> T clazz(String ... classes) {
        this.put("class", String.join((CharSequence)" ", classes));
        return (T)this;
    }

    public <T extends Tag> T content(String content) {
        this.content = content == null ? null : content.trim();
        return (T)this;
    }

    public <T extends Tag> T id(String id) {
        return this.attr("id", id);
    }

    public boolean is(String type) {
        return this.type != null && this.type.equalsIgnoreCase(type);
    }

    public <T extends Tag> T pos(int x, int y) {
        return ((Tag)this.attr("x", x)).attr("y", y);
    }

    public <T extends Tag> T size(int width, int height) {
        return ((Tag)this.attr("width", width)).attr("height", height);
    }

    public <T extends Tag> T style(String style) {
        return this.attr("style", style);
    }

    public <T extends Tag> T title(String t) {
        return this.attr("title", t);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("<" + this.type);
        for (Map.Entry entry : this.entrySet()) {
            sb.append(" ").append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\"");
        }
        if (this.children.isEmpty()) {
            sb.append(" />");
        } else {
            sb.append(">");
            for (Tag child : this.children) {
                sb.append(child.toString());
            }
            sb.append("</").append(this.type).append(">");
        }
        return sb.toString();
    }

    protected void indent(StringBuilder sb, int indent, int currentIndentation) {
        sb.append(" ".repeat(currentIndentation)).append("<").append(this.type);
        for (Map.Entry entry : this.entrySet()) {
            sb.append(" ").append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\"");
        }
        if (this.children.isEmpty()) {
            if (this.content == null) {
                sb.append(" />\n");
            } else {
                sb.append(">").append(this.content).append("</").append(this.type).append(">\n");
            }
        } else {
            sb.append(">\n");
            for (Tag child : this.children) {
                child.indent(sb, indent, currentIndentation + indent);
            }
            sb.append(" ".repeat(currentIndentation)).append("</").append(this.type).append(">\n");
        }
    }

    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        this.indent(sb, indent, 0);
        return sb.toString();
    }

    public String type() {
        return this.type;
    }
}

